﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundProjectUtility.Resources;
using System.Diagnostics;

namespace NintendoWare.SoundProjectUtility
{
    /// <summary>
    /// ローカライズに対応したコマンドラインオプション設定の基底クラスです。
    /// </summary>
    public class LocalizableSettings
    {
        /// <summary>
        /// ローカライズしたオプションの説明を取得します。
        /// </summary>
        /// <param name="description">Descriptionプロパティの値</param>
        /// <param name="valueName">引数名またはオプション名</param>
        /// <returns>ローカライズされたコマンドラインオプションの説明を返します。</returns>
        public static string LocalizeDescription(string description, string valueName)
        {
            string result = MessageResources.ResourceManager.GetString(description, MessageResources.Culture);
            Debug.Assert(result != null, "コマンドオプションの Description が null");

            return result;
        }
    }
}
