﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Configuration;
using System.IO;
using System.Reflection;

namespace NintendoWare.SoundProjectUtility
{
    /// <summary>
    /// .config ファイルから情報を取得します
    /// </summary>
    public class ConfigurationFileUtility
    {
        private static string GetExpandedAppSetting(string key)
        {
            return ExpandMacro(ConfigurationManager.AppSettings[key]);
        }

        private static string ExpandMacro(string value)
        {
            string executingDirectory = Path.GetFullPath(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location));

            return value.Replace("$(SoundMakerDirectory)", executingDirectory);
        }
    }
}
