﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Preview.Communications
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;

    public delegate bool ConnectDelegate(object param);
    public delegate void DisconnectDelegate();
    public delegate bool IsConnectDelegate();
    public delegate ConnectionState GetStateDelegate();

    public class ConnectionInfo
    {
        string targetName;
        string targetNameLabel;
        bool useCustomConnection;
        ConnectDelegate connectDelegate;
        DisconnectDelegate disconnectDelegate;
        IsConnectDelegate isConnectedDelegate;
        IsConnectDelegate isConnectingDelegate;
        IsConnectDelegate isConnectedSndEditDelegate;
        IsConnectDelegate isConnectingSndEditDelegate;
        GetStateDelegate getStateDelegate;
        CommManager commManager;
        string peerType;

        public ConnectionInfo(string targetName,
                              string targetNameLabel,
                              bool useCustomConnection,
                              ConnectDelegate connectDelegate,
                              DisconnectDelegate disconnectDelegate,
                              IsConnectDelegate isConnectedDelegate,
                              IsConnectDelegate isConnectingDelegate,
                              IsConnectDelegate isConnectedSndEditDelegate,
                              IsConnectDelegate isConnectingSndEditDelegate,
                              GetStateDelegate getStateDelegate,
                              CommManager commManager,
                              string peerType = null)
        {
            this.targetName = targetName;
            this.targetNameLabel = targetNameLabel;
            this.useCustomConnection = useCustomConnection;
            this.connectDelegate = connectDelegate;
            this.disconnectDelegate = disconnectDelegate;
            this.isConnectedDelegate = isConnectedDelegate;
            this.isConnectingDelegate = isConnectingDelegate;
            this.isConnectedSndEditDelegate = isConnectedSndEditDelegate;
            this.isConnectingSndEditDelegate = isConnectingSndEditDelegate;
            this.getStateDelegate = getStateDelegate;
            this.commManager = commManager;
            this.peerType = peerType;
        }

        // 接続先の名前　例）WiiU-Application, PC-SoundPlayer 等
        public string TargetName
        {
            get
            {
                return this.targetName;
            }
        }

        public string TargetNameLabel
        {
            get
            {
                return this.targetNameLabel;
            }
        }

        public CommManager CommManager
        {
            get
            {
                return this.commManager;
            }
        }

        public string PeerType
        {
            get
            {
                return this.peerType;
            }
        }

        public bool Connect()
        {
            if (this.connectDelegate != null)
            {
                return this.connectDelegate(null);
            }

            return false;
        }

        public bool Connect(object param)
        {
            if (this.connectDelegate != null)
            {
                return this.connectDelegate(param);
            }

            return false;
        }

        public void Disconnect()
        {
            this.disconnectDelegate();
        }

        public bool IsConnected
        {
            get
            {
                return (this.isConnectedDelegate != null && this.isConnectedDelegate());
            }
        }

        public bool IsConnecting
        {
            get
            {
                return (this.isConnectingDelegate != null && this.isConnectingDelegate());
            }
        }

        public bool IsConnectedSndEdit
        {
            get
            {
                return (this.isConnectedSndEditDelegate != null && this.isConnectedSndEditDelegate());
            }
        }

        public bool IsConnectingSndEdit
        {
            get
            {
                return (this.isConnectingSndEditDelegate != null && this.isConnectingSndEditDelegate());
            }
        }

        public bool UseCustomConnection
        {
            // 接続が有効かどうか（無効な場合は exe 側で htcs 接続になる）
            get
            {
                return this.useCustomConnection;
            }
        }

        public ConnectionState GetState()
        {
            if (this.getStateDelegate != null)
            {
                return this.getStateDelegate();
            }

            return ConnectionState.Disconnected;
        }
    }
}
