﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMakerPlugin
{
    public interface ISequenceSoundPlayer
    {
        void Initialize();
        void Setup(uint allocTrackFlag, RuntimeNoteOnCallback callback, object userData);
        void ForceTrackMute(uint trackMask);
        short GetLocalVariable(int varNo);
        short GetTrackVariable(int trackNo, int varNo);
        void SetSeqData(IntPtr seq, IntPtr[] banks, IntPtr[] warcs, bool[] warcsIsIndividuals, int seqOffset);
        void SetVolume(float volume);
        void SetChannelPriority(int prio);
        void SetLocalVariable(int varNo, short var);
        void SetTrackVariable(int trackNo, int varNo, short var);
        bool IsActive();
        bool IsPause();
        bool IsPlayFinished();
        void Pause(bool flag);
        void Start();
        void Stop();
    }
}
