﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMakerPlugin
{
    using NintendoWare.SoundFoundation.Conversion;
    using NintendoWare.SoundFoundation.Conversion.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.FileFormats;
    using NintendoWare.SoundMaker.Preview;
    using NintendoWare.SoundMaker.Preview.Communications;

    public delegate SoundIntermediateOutputTraits CreateSoundIntermediateOutputTraitsDelegate();
    public delegate SoundBinaryOutputTraits CreateSoundBinaryOutputTraitsDelegate();
    public delegate SoundProjectConversionTraits CreateSoundProjectConversionTraitsDelegate(SoundIntermediateOutputTraits intermediateOutputTraits, SoundBinaryOutputTraits binaryOutputTraits, SequenceSoundTextConverter sequenceSoundTextConverter, SmfConverter smfConverter);

    public enum RendererType
    {
        k32KHz = 0,
        k48KHz = 1,
    }

    public interface ISoundMakerPlugin
    {
        string Platform { get; }
#if DEBUG
        string GetMessage();
#endif
        // Preview 関連のインターフェース

        int RuntimeSoundSystem_GetActiveVoiceCount();
        void RuntimeSoundSystem_LockSoundThread();
        void RuntimeSoundSystem_UnlockSoundThread();
        void RuntimeSoundSystem_StopAllVoices();
        void RuntimeSoundSystem_SoundThreadPause(bool pauseFlag);
        void RuntimeSoundSystem_SoundFrameProcess();
        void RuntimeSoundSystem_InitSoundSystem(int soundThreadPriority, int dvdThreadPriority);
        void RuntimeSoundSystem_ShutdownSoundSystem();

        bool IsNwRendererEnabled { get; }

        int RuntimeGlobal_DefaultSampleRate { get; }
        int RuntimeGlobal_CHANNEL_COUNT { get; }
        int RuntimeGlobal_MSEC_PER_FRAME { get; }
        int RuntimeGlobal_AXSynthesize(short[] buffer, int samplingRate);
        void RuntimeGlobal_AXInit();
        void RuntimeGlobal_AXQuit();

        void InitializeAudioDevice(string deviceName);
        IEnumerable<string> EnumerateAudioDeviceNames();

        short RuntimeSequenceSoundPlayer_GetGlobalVariable(int varNo);
        void RuntimeSequenceSoundPlayer_SetGlobalVariable(int varNo, short var);

        IPreviewSequenceChannel CreatePreviewSequenceChannel(string bankFileName, Instrument instrument, ref IRuntimeNoteOnInfo noteOnInfo);
        IPreviewSequenceChannel CreatePreviewSequenceChannel(string bankFileName, ref IRuntimeNoteOnInfo noteOnInfo, RendererType rendererType);
        IPreviewWaveChannel CreatePreviewWaveChannel(WaveSoundBase sound, RendererType rendererType, bool forceNoLoop = false);
        IPreviewStreamChannel CreatePreviewStreamChannel(
            StreamSoundTrackBase streamTrack,
            StreamSoundTrackBase baseTrack,
            int channelIndexStart,
            float volume,
            float pitch,
            PanMode panMode,
            PanCurve panCurve,
            float mainSend,
            RendererType rendererType,
            bool forceNoLoop = false);
        ISequenceSoundPlayer CreateSequenceSoundPlayer();
        ISeqFileReader CreateSeqFileReader(IntPtr seqData);
        ISequenceSoundBinaryReader CreateSequenceSoundBinaryReader();
        IMidiManager CreateMidiManager();

        // Converter 関連のインターフェース
        CreateSoundProjectConverterDelegate GetCreateSoundProjectConverterDelegate();
        CreateSoundIDCppHeaderExporterDelegate GetCreateSoundIDCppHeaderExporterDelegate();
        CreateSoundArchiveBinaryMapExporterDelegate GetCreateSoundArchiveBinaryMapExporterDelegate();

        CreateFileIDAggregateFactoryDelegate GetCreateFileIDAggregateFactoryDelegate();
        CreateFileIDDelegate GetCreateFileIDDelegate();
        CreateSoundArchiveBinaryXmlDelegate GetCreateSoundArchiveBinaryXmlDelegate();

        CreateWaveFileInfoDelegate GetCreateWaveFileInfoDelegate();

        // 接続関連
        CommunicationInfo CommunicationInfo { get; }

        // その他
        void Initialize(SoundSetComponentFactory soundSetComponentFactory);

        string GetExpandedAppSetting(string key);
        IEnumerable<IDocumentFactory> DocumentFactories { get; }
        IEnumerable<IDocumentReader> DocumentReaders { get; }

        // コントロール関係
        string PlatformLabel { get; }
        bool IsValidateWaveEncodingValue(WaveEncoding encoding);

        // TargetPlayer 関係（実機版の Player の事です。具体的には、実機版 AtkPlayer, 実機版 SoundPlayer 等）
        ITargetPlayer TargetPlayer { get; }
    }
}
