﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text.RegularExpressions;
    using System.Windows.Forms;

    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Utilities;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public class ImaginaryInstrument : Instrument
    {
        private Instrument instrument = null;
        private string bankFilePath = null;

        /// <summary>
        ///
        /// </summary>
        public ImaginaryInstrument(Component component, string bankFilePath)
        {
            Debug.Assert(component is Instrument, "Component is not Instrument");
            this.instrument = component as Instrument;

            Name = this.instrument.Name;
            Comment = this.instrument.Comment;
            Comment1 = this.instrument.Comment1;
            Comment2 = this.instrument.Comment2;
            Comment3 = this.instrument.Comment3;
            Comment4 = this.instrument.Comment4;
            Comment5 = this.instrument.Comment5;
            Comment6 = this.instrument.Comment6;
            Comment7 = this.instrument.Comment7;
            Comment8 = this.instrument.Comment8;
            Comment9 = this.instrument.Comment9;

            this.bankFilePath = bankFilePath;
            this.instrument.UpdateLinkedRegion();
        }

        /// <summary>
        ///
        /// </summary>
        public Instrument TargetInstrument
        {
            get
            {
                return this.instrument;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string BankFilePath
        {
            get
            {
                return this.bankFilePath;
            }
        }

        /// <summary>
        /// 有効/無効
        /// </summary>
        public override bool IsEnabled
        {
            get { return this.instrument.IsEnabled; }
            set { }
        }

        /// <summary>
        /// カラーのインデックス
        /// </summary>
        public override int ColorIndex
        {
            get { return this.instrument.ColorIndex; }
            set { }
        }

        /// <summary>
        ///
        /// </summary>
        public override bool LinkedRegion
        {
            get
            {
                return this.instrument.LinkedRegion;
            }
        }
    }

    /// <summary>
    /// インストルメントのリストアイテム
    /// </summary>
    public class ImaginaryInstrumentListItem : InstrumentListItem
    {
        private SoundSetBankBase[] referencedSoundSetBanks = null;
        private string referencedSoundSetBankText = null;

        /// <summary>
        ///
        /// </summary>
        public ImaginaryInstrumentListItem(Component component, SoundSetBankBase[] referencedSoundSetBanks) : base(component)
        {
            this.referencedSoundSetBanks = referencedSoundSetBanks;

            //
            if (this.referencedSoundSetBanks == null ||
                this.referencedSoundSetBanks.Length <= 0)
            {
                this.referencedSoundSetBankText = NotAvailable.Text;
            }
            else
            {
                foreach (SoundSetBankBase soundSetBank in this.referencedSoundSetBanks)
                {
                    if (this.referencedSoundSetBankText != null)
                    {
                        this.referencedSoundSetBankText += ", ";
                    }
                    this.referencedSoundSetBankText += soundSetBank.Name;
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public override Component Target
        {
            get
            {
                ImaginaryInstrument imaginaryInstrument = base.Target as ImaginaryInstrument;
                Debug.Assert(imaginaryInstrument != null, "Target is not imaginary instrument.");
                return imaginaryInstrument.TargetInstrument;
            }
            set
            {
                base.Target = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public ImaginaryInstrument ImaginaryInstrument
        {
            get
            {
                ImaginaryInstrument imaginaryInstrument = base.Target as ImaginaryInstrument;
                Debug.Assert(imaginaryInstrument != null, "Target is not imaginary instrument.");
                return imaginaryInstrument;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public override IConstParameterValue GetConstValue(string name)
        {
            if (name == ProjectParameterNames.SequenceSound.SoundSetBankReference0)
            {
                return new TextParameterValue(this.referencedSoundSetBankText);
            }

            return base.GetConstValue(name);
        }
    }
}
