﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Diagnostics;
    using System.Drawing;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public enum TextDisplayMessageBoxStyle
    {
        OKButton,
        OKAndLogButton,
        YesAndNoButton
    }

    public partial class TextDisplayMessageBox : Form
    {
        private string logFilePath;

        public TextDisplayMessageBox(
                                     string message,
                                     string text,
                                     TextDisplayMessageBoxStyle style
                                     )
            : this(message, text)
        {
            this.buttonYes.Enabled = true;
            this.buttonYes.Visible = true;
            this.buttonNo.Enabled = true;
            this.buttonNo.Visible = true;
            this.buttonOK.Enabled = true;
            this.buttonOK.Visible = true;
            this.buttonLog.Enabled = false;
            this.buttonLog.Visible = false;

            switch (style)
            {
                case TextDisplayMessageBoxStyle.OKButton:
                    this.buttonYes.Enabled = false;
                    this.buttonYes.Visible = false;
                    this.buttonNo.Enabled = false;
                    this.buttonNo.Visible = false;
                    this.buttonLog.Enabled = false;
                    this.buttonLog.Visible = false;
                    break;

                case TextDisplayMessageBoxStyle.OKAndLogButton:
                    this.buttonYes.Enabled = false;
                    this.buttonYes.Visible = false;
                    this.buttonNo.Enabled = false;
                    this.buttonNo.Visible = false;
                    break;

                case TextDisplayMessageBoxStyle.YesAndNoButton:
                    this.buttonOK.Enabled = false;
                    this.buttonOK.Visible = false;
                    this.buttonLog.Enabled = false;
                    this.buttonLog.Visible = false;
                    break;
            }
        }

        public TextDisplayMessageBox(string message, string text)
        {
            InitializeComponent();

            System.Reflection.AssemblyProductAttribute asmprd =
                (System.Reflection.AssemblyProductAttribute)
                Attribute.GetCustomAttribute(
                                             System.Reflection.Assembly.GetEntryAssembly(),
                                             typeof(System.Reflection.AssemblyProductAttribute)
                                             );
            this.Text = asmprd.Product;

            this.labelMessage.Text = message;
            this.richTextBox.Text = text;
        }

        public string LogFilePath
        {
            get
            {
                return logFilePath;
            }
            set
            {
                if (value != null &&
                    value != string.Empty &&
                    File.Exists(value) == true)
                {
                    logFilePath = value;
                    this.buttonLog.Enabled = true;
                    this.buttonLog.Visible = true;
                }
                else
                {
                    this.buttonLog.Enabled = false;
                    this.buttonLog.Visible = false;
                }
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.Control == false)
            {
                if (e.KeyCode == Keys.Y)
                {
                    DialogResult = DialogResult.OK;
                }
                else if (e.KeyCode == Keys.N)
                {
                    DialogResult = DialogResult.Cancel;
                }
            }
        }

        private void OnButtonLogClick(object sender, EventArgs e)
        {
            if (this.LogFilePath != null &&
                this.LogFilePath != string.Empty &&
                File.Exists(this.LogFilePath) != false)
            {
                Process.Start(this.LogFilePath);
            }
        }
    }
}
