﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Diagnostics;
    using System.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// WindowsForms ベースのメッセージボックスを表示します。
    /// </summary>
    public static class FormsMessageBox
    {
        /// <summary>
        /// メッセージボックスを表示します。
        /// </summary>
        /// <param name="text">テキスト。</param>
        /// <param name="caption">キャプション。</param>
        /// <param name="button">ボタンの種類。</param>
        /// <param name="image">アイコン。</param>
        /// <param name="defaultResult">デフォルトの結果。</param>
        /// <returns>結果。</returns>
        public static AppMessageBoxResult Show(IWin32Window owner, string text, string caption, AppMessageBoxButton button,
                                   AppMessageBoxImage image, AppMessageBoxResult defaultResult)
        {
            DialogResult result = DialogResult.None;

            if (AppMessageBoxResult.None == defaultResult)
            {
                result = MessageBox.Show(owner, text, (null == caption) ? Application.ProductName : caption,
                                        App2FormsButtonType(button), App2FormsImageType(image));
            }
            else
            {
                result = MessageBox.Show(owner, text, (null == caption) ? Application.ProductName : caption,
                                        App2FormsButtonType(button), App2FormsImageType(image),
                                        GetDefaultButton(button, defaultResult));
            }

            return Forms2AppResultType(result);
        }

        private static MessageBoxButtons App2FormsButtonType(AppMessageBoxButton button)
        {
            switch (button)
            {
                case AppMessageBoxButton.OK:
                    return MessageBoxButtons.OK;

                case AppMessageBoxButton.OKCancel:
                    return MessageBoxButtons.OKCancel;

                case AppMessageBoxButton.YesNo:
                    return MessageBoxButtons.YesNo;

                case AppMessageBoxButton.YesNoCancel:
                    return MessageBoxButtons.YesNoCancel;
            }

            throw new ArgumentException("invalid message box button type.");
        }

        private static MessageBoxIcon App2FormsImageType(AppMessageBoxImage image)
        {
            switch (image)
            {
                case AppMessageBoxImage.None:
                    return MessageBoxIcon.None;

                case AppMessageBoxImage.Hand:
                    return MessageBoxIcon.Hand;

                case AppMessageBoxImage.Question:
                    return MessageBoxIcon.Question;

                case AppMessageBoxImage.Exclamation:
                    return MessageBoxIcon.Exclamation;

                case AppMessageBoxImage.Asterisk:
                    return MessageBoxIcon.Asterisk;

                case AppMessageBoxImage.Stop:
                    return MessageBoxIcon.Stop;

                case AppMessageBoxImage.Error:
                    return MessageBoxIcon.Error;

                case AppMessageBoxImage.Warning:
                    return MessageBoxIcon.Warning;

                case AppMessageBoxImage.Information:
                    return MessageBoxIcon.Information;
            }

            throw new ArgumentException("invalid message box image type.");
        }

        private static DialogResult App2FormsResultType(AppMessageBoxResult result)
        {
            switch (result)
            {
                case AppMessageBoxResult.None:
                    return DialogResult.None;

                case AppMessageBoxResult.Cancel:
                    return DialogResult.Cancel;

                case AppMessageBoxResult.OK:
                    return DialogResult.OK;

                case AppMessageBoxResult.Yes:
                    return DialogResult.Yes;

                case AppMessageBoxResult.No:
                    return DialogResult.No;
            }

            throw new ArgumentException("invalid message box result type.");
        }

        private static AppMessageBoxResult Forms2AppResultType(DialogResult result)
        {
            switch (result)
            {
                case DialogResult.None:
                    return AppMessageBoxResult.None;

                case DialogResult.Cancel:
                    return AppMessageBoxResult.Cancel;

                case DialogResult.OK:
                    return AppMessageBoxResult.OK;

                case DialogResult.Yes:
                    return AppMessageBoxResult.Yes;

                case DialogResult.No:
                    return AppMessageBoxResult.No;
            }

            throw new ArgumentException("invalid message box result type.");
        }

        private static MessageBoxDefaultButton GetDefaultButton(AppMessageBoxButton button, AppMessageBoxResult defaultResult)
        {
            switch (button)
            {
                case AppMessageBoxButton.OK:
                    switch (defaultResult)
                    {
                        case AppMessageBoxResult.OK:
                            return MessageBoxDefaultButton.Button1;
                    }
                    break;

                case AppMessageBoxButton.OKCancel:
                    switch (defaultResult)
                    {
                        case AppMessageBoxResult.OK:
                            return MessageBoxDefaultButton.Button1;
                        case AppMessageBoxResult.Cancel:
                            return MessageBoxDefaultButton.Button2;
                    }
                    break;

                case AppMessageBoxButton.YesNo:
                    switch (defaultResult)
                    {
                        case AppMessageBoxResult.Yes:
                            return MessageBoxDefaultButton.Button1;

                        case AppMessageBoxResult.No:
                            return MessageBoxDefaultButton.Button2;
                    }
                    break;

                case AppMessageBoxButton.YesNoCancel:
                    switch (defaultResult)
                    {
                        case AppMessageBoxResult.Yes:
                            return MessageBoxDefaultButton.Button1;

                        case AppMessageBoxResult.No:
                            return MessageBoxDefaultButton.Button2;

                        case AppMessageBoxResult.Cancel:
                            return MessageBoxDefaultButton.Button3;
                    }
                    break;
            }

            Debug.Fail("invalid message box button type.");

            return MessageBoxDefaultButton.Button1;
        }
    }
}
