﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using NintendoWare.SoundFoundation.Projects;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    /// <summary>
    /// コンポーネントをコントロールのアイテムとして扱えるようにします。
    /// </summary>
    public class ComponentUIControlItem
    {
        private Component _component;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="component">対象コンポーネント。</param>
        public ComponentUIControlItem(Component component)
        {
            if (null == component) { throw new ArgumentNullException("component"); }
            _component = component;
        }

        /// <summary>
        /// コンポーネントを取得します。
        /// </summary>
        public Component Component
        {
            get { return _component; }
        }

        /// <summary>
        /// コンポーネントの名前を取得します。
        /// </summary>
        /// <returns>コンポーネントの名前。</returns>
        public override string ToString()
        {
            return _component.Name;
        }
    }
}
