﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Diagnostics;
    using System.Drawing;
    using System.IO;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.CommandBars;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public class CommandTextReplacer
    {
        private static string[] AcceleratorTexts = new string[] {
            "(&N)",
            "(&R)",
            "(&O)",
            "(&Y)",
            "(&G)",
            "(&A)",
            "(&B)",
            "(&P)",
            "(&I)",
        };

        ///
        private static string[] defaultColorComments = null;

        /// <summary>
        ///
        /// </summary>
        public static string[] DefaultColorComments
        {
            get
            {
                return defaultColorComments;
            }
        }

        /// <summary>
        /// ユーザーコマンドのコマンドのテキストを書き換えます。
        /// </summary>
        public static void ReplaceUserCommandCommandTexts(SoundProjectService projectService, ToolStripAdapter adapter)
        {
            if (adapter == null) { return; }

            UserCommand[] userCommands = projectService.Project.UserCommands;
            Color color = UIServiceBase.TransparentColor;

            ReplaceText(adapter, ToolCommands.UserCommand1,
                         ImageResource.BitmapIconUserCommand1.MakeNewTransparent(color),
                         userCommands[0].Name, "(&1)",
                         GetAbsoluteFilePath(projectService, userCommands[0].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand2,
                         ImageResource.BitmapIconUserCommand2.MakeNewTransparent(color),
                         userCommands[1].Name, "(&2)",
                         GetAbsoluteFilePath(projectService, userCommands[1].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand3,
                         ImageResource.BitmapIconUserCommand3.MakeNewTransparent(color),
                         userCommands[2].Name, "(&3)",
                         GetAbsoluteFilePath(projectService, userCommands[2].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand4,
                         ImageResource.BitmapIconUserCommand4.MakeNewTransparent(color),
                         userCommands[3].Name, "(&4)",
                         GetAbsoluteFilePath(projectService, userCommands[3].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand5,
                         ImageResource.BitmapIconUserCommand5.MakeNewTransparent(color),
                         userCommands[4].Name, "(&5)",
                         GetAbsoluteFilePath(projectService, userCommands[4].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand6,
                         ImageResource.BitmapIconUserCommand6.MakeNewTransparent(color),
                         userCommands[5].Name, "(&6)",
                         GetAbsoluteFilePath(projectService, userCommands[5].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand7,
                         ImageResource.BitmapIconUserCommand7.MakeNewTransparent(color),
                         userCommands[6].Name, "(&7)",
                         GetAbsoluteFilePath(projectService, userCommands[6].IconFilePath));

            ReplaceText(adapter, ToolCommands.UserCommand8,
                         ImageResource.BitmapIconUserCommand8.MakeNewTransparent(color),
                         userCommands[7].Name, "(&8)",
                         GetAbsoluteFilePath(projectService, userCommands[7].IconFilePath));
        }

        /// <summary>
        /// カラーコメントのコマンドのテキストを書き換えます。
        /// </summary>
        public static void ReplaceColorCommentCommandTexts(SoundProjectService projectService, ToolStripAdapter adapter)
        {
            if (adapter == null) { return; }

            Replace(projectService, adapter, 0, EditCommands.SetItemColor);
            Replace(projectService, adapter, 1, EditCommands.SetItemColorRed);
            Replace(projectService, adapter, 2, EditCommands.SetItemColorOrange);
            Replace(projectService, adapter, 3, EditCommands.SetItemColorYellow);
            Replace(projectService, adapter, 4, EditCommands.SetItemColorGreen);
            Replace(projectService, adapter, 5, EditCommands.SetItemColorLightBlue);
            Replace(projectService, adapter, 6, EditCommands.SetItemColorBlue);
            Replace(projectService, adapter, 7, EditCommands.SetItemColorPurple);
            Replace(projectService, adapter, 8, EditCommands.SetItemColorPink);
        }

        /// <summary>
        /// カラーコメントのコマンドのテキストを退避しておきます。
        /// カラーコメントを設定されていない場合に表示する為です。
        /// </summary>
        public static void PreserveDefaultColorComment(ToolStripAdapter adapter)
        {
            Command[] commands = new Command[]
                {
                    EditCommands.SetItemColor,
                    EditCommands.SetItemColorRed,
                    EditCommands.SetItemColorOrange,
                    EditCommands.SetItemColorYellow,
                    EditCommands.SetItemColorGreen,
                    EditCommands.SetItemColorLightBlue,
                    EditCommands.SetItemColorBlue,
                    EditCommands.SetItemColorPurple,
                    EditCommands.SetItemColorPink,
                };

            defaultColorComments = new string[commands.Length];

            for (int index = 0; index < commands.Length; index++)
            {
                CommandBarItem[] items = adapter.Find(commands[index]);
                if (items.Length > 0)
                {
                    defaultColorComments[index] = items[0].Text;
                }
            }
        }

        /// <summary>
        /// 相対パスをプロジェクトファイルからの絶対パスとして取得します。
        /// 絶対パスが渡された場合には、そのままの値を返します。
        /// </summary>
        private static string GetAbsoluteFilePath(SoundProjectService projectService, string filePath)
        {
            if (String.IsNullOrEmpty(filePath) != false)
            {
                return null;
            }

            if (Path.IsPathRooted(filePath) == false)
            {
                string projectDirectory = Path.GetDirectoryName(projectService.ProjectFilePath);
                filePath = Path.GetFullPath(Path.Combine(projectDirectory, filePath));
            }
            return filePath;
        }

        /// <summary>
        ///
        /// </summary>
        private static void ReplaceText(ToolStripAdapter adapter, Command command, Image defaultIcon, string text, string acceleratorText, string iconFilePath)
        {
            CommandBarItem[] items = adapter.Find(command);
            if (items == null)
            {
                Debug.Assert(false, "Menu item not found");
                return;
            }

            foreach (CommandBarItem item in items)
            {
                if (item is CommandBarExecutableItem)
                {
                    CommandBarExecutableItem executableItem = item as CommandBarExecutableItem;
                    executableItem.ToolTipText = text;

                    Image image = defaultIcon;
                    if (String.IsNullOrEmpty(iconFilePath) == false)
                    {
                        try
                        {
                            image = new Bitmap(iconFilePath).MakeNewTransparent(UIServiceBase.TransparentColor);
                        }
                        catch
                        {
                        }
                    }
                    executableItem.Image = image.Clone() as Image;
                    image.Dispose();
                }

                item.Text = String.Format("{0} {1}", text, acceleratorText);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private static void Replace(SoundProjectService projectService, ToolStripAdapter adapter, int index, Command command)
        {
            CommandBarItem[] items = adapter.Find(command);
            if (items == null)
            {
                Debug.Assert(false, "Menu item not found");
                return;
            }

            string text = null;
            switch (index)
            {
                case 0: text = projectService.Project.ColorComment0; break;
                case 1: text = projectService.Project.ColorComment1; break;
                case 2: text = projectService.Project.ColorComment2; break;
                case 3: text = projectService.Project.ColorComment3; break;
                case 4: text = projectService.Project.ColorComment4; break;
                case 5: text = projectService.Project.ColorComment5; break;
                case 6: text = projectService.Project.ColorComment6; break;
                case 7: text = projectService.Project.ColorComment7; break;
                case 8: text = projectService.Project.ColorComment8; break;
                default: Debug.Assert(false, "Illigal index"); break;
            }

            if (text == String.Empty)
            {
                text = defaultColorComments[index];
            }
            else
            {
                text = text + AcceleratorTexts[index];
            }

            foreach (CommandBarItem item in items)
            {
                item.Text = text;
            }
        }
    }
}
