﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;

    public partial class BookMarkPanel : DockingPage, IToolWindowPage, ICommandTarget
    {
        public const string PageName = "BookMark";

        public BookMarkPanel() : base( PageName )
        {
            InitializeComponent();

            Text  = MessageResource.ToolWindowName_BookMark;

            FloatingBounds = new Rectangle(-1, -1,
                                           Width + (SystemInformation.FrameBorderSize.Width * 2),
                                           Height + SystemInformation.CaptionHeight + SystemInformation.FrameBorderSize.Height );

        }

        public BookMarkListPanel BookMarkListPanel
        {
            get { return this.bookMarkListPanel; }
        }

        /// <summary>
        /// 指定コマンドを処理するコマンドターゲットを検索します。
        /// </summary>
        /// <param name="command">処理するコマンド。</param>
        /// <returns>コマンドターゲット。</returns>
        ICommandTarget ICommandTarget.FindTarget( Command command )
        {
            return null;
            //return ( _projectPanel as ICommandTarget ).FindTarget( command );
        }

        /// <summary>
        /// 指定コマンドを実行できるかどうか調べます。
        /// </summary>
        /// <param name="command">実行するコマンド。</param>
        /// <returns>コマンドの状態。</returns>
        CommandStatus ICommandTarget.QueryStatus( Command command )
        {
            return CommandStatus.SupportedAndEnabledAndVisible;
            //return ( _projectPanel as ICommandTarget ).QueryStatus( command );
        }

        /// <summary>
        /// 指定コマンドを実行します。
        /// </summary>
        /// <param name="command">実行するコマンド。</param>
        bool ICommandTarget.Execute( Command command )
        {
            return true;
            //return ( _projectPanel as ICommandTarget ).Execute( command );
        }
    }
}
