﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public static class FindResultSettings
    {
        public static Brush DisableTextBrush { get; set; }

        static FindResultSettings()
        {
            Color baseColor = SystemColors.WindowText;
            int r = baseColor.R + (int)((float)(255 - baseColor.R) * 0.8F);
            int g = baseColor.G + (int)((float)(255 - baseColor.G) * 0.8F);
            int b = baseColor.B + (int)((float)(255 - baseColor.B) * 0.8F);
            DisableTextBrush = new SolidBrush(Color.FromArgb(baseColor.A, r, g, b));
            ExtendListColumnStyles = new List<ListColumnStyle>();

            /// 定義順に登録されますので順番が重要です。
            ExtendHeaderColumnDatas = new List<ExtendHeaderColumnData>() {
                new ExtendHeaderColumnData() {
                    PreviousColumnName = ProjectParameterNames.Volume,
                    HeaderColumnData = new HeaderColumnData() {
                        Name = ProjectParameterNames.StreamSoundTrack.TrackVolume,
                        Text = MessageResource.HeaderText_TrackVolume,
                        Length = 64,
                        Visible = true,
                    },
                },
                new ExtendHeaderColumnData() {
                    PreviousColumnName = ProjectParameterNames.Sends.MainSend,
                    HeaderColumnData = new HeaderColumnData() {
                        Name = ProjectParameterNames.StreamSoundTrack.Sends.AuxASend,
                        Text = MessageResource.HeaderText_TrackAuxASend,
                        Length = 80,
                        Visible = true,
                    },
                },
                new ExtendHeaderColumnData() {
                    PreviousColumnName = ProjectParameterNames.StreamSoundTrack.Sends.AuxASend,
                    HeaderColumnData = new HeaderColumnData() {
                        Name = ProjectParameterNames.StreamSoundTrack.Sends.AuxBSend,
                        Text = MessageResource.HeaderText_TrackAuxBSend,
                        Length = 80,
                        Visible = true,
                    },
                },
                new ExtendHeaderColumnData() {
                    PreviousColumnName = ProjectParameterNames.StreamSoundTrack.Sends.AuxBSend,
                    HeaderColumnData = new HeaderColumnData() {
                        Name = ProjectParameterNames.StreamSoundTrack.Sends.MainSend,
                        Text = MessageResource.HeaderText_TrackMainSend,
                        Length = 80,
                        Visible = true,
                    },
                },
            };

            ReplacedParameterNames = new Dictionary<string, string> {

                { ProjectParameterNames.StreamSoundTrack.TrackVolume,
                  ProjectParameterNames.Volume },

                { ProjectParameterNames.StreamSoundTrack.Sends.MainSend,
                  ProjectParameterNames.Sends.MainSend },

                { ProjectParameterNames.StreamSoundTrack.Sends.AuxASend,
                  ProjectParameterNames.Sends.AuxASend },

                { ProjectParameterNames.StreamSoundTrack.Sends.AuxBSend,
                  ProjectParameterNames.Sends.AuxBSend },
            };

            ReferenceParentParameterNames = new HashSet<string> {

                ProjectParameterNames.WaveEncoding,

                ProjectParameterNames.Volume,

                ProjectParameterNames.Sound.PlayerPriority,
                ProjectParameterNames.Sound.PlayerReference,
                ProjectParameterNames.Sound.ActorPlayer,

                ProjectParameterNames.Sound3D.DecayCurve3D,
                ProjectParameterNames.Sound3D.DecayRatio3D,
                ProjectParameterNames.Sound3D.DopplerFactor3D,
                ProjectParameterNames.Sound3D.Enable3DFilter,
                ProjectParameterNames.Sound3D.Enable3DPan,
                ProjectParameterNames.Sound3D.Enable3DPriority,
                ProjectParameterNames.Sound3D.Enable3DSurroundPan,
                ProjectParameterNames.Sound3D.Enable3DVolume,

                ProjectParameterNames.PanMode,
                ProjectParameterNames.PanCurve,
                ProjectParameterNames.Pitch,

                ProjectParameterNames.Sends.MainSend,
                ProjectParameterNames.Sends.AuxASend,
                ProjectParameterNames.Sends.AuxBSend,

                ProjectParameterNames.Sound.PlayerReference,

                ProjectParameterNames.UserParameter,
                ProjectParameterNames.UserParameter1,
                ProjectParameterNames.UserParameter2,
                ProjectParameterNames.UserParameter3,

                ProjectParameterNames.Comment,
                ProjectParameterNames.Comment1,
                ProjectParameterNames.Comment2,
                ProjectParameterNames.Comment3,
                ProjectParameterNames.Comment4,
                ProjectParameterNames.Comment5,
                ProjectParameterNames.Comment6,
                ProjectParameterNames.Comment7,
                ProjectParameterNames.Comment8,
                ProjectParameterNames.Comment9,
            };
        }

        /// <summary>
        ///
        /// </summary>
        public static List<ListColumnStyle> ExtendListColumnStyles { get; set; }

        /// <summary>
        ///
        /// </summary>
        public class ExtendHeaderColumnData
        {
            public string PreviousColumnName { get; set; }
            public HeaderColumnData HeaderColumnData { get; set; }

        }

        /// <summary>
        /// 定義順に登録されますので順番が重要です。
        /// </summary>
        public static List<ExtendHeaderColumnData> ExtendHeaderColumnDatas { get; set; }

        /// <summary>
        /// パラメータ名が変更されて値が取得されるパラメータ名です。
        /// </summary>
        public static Dictionary<string, string> ReplacedParameterNames { get; set; }

        /// <summary>
        ///
        /// </summary>
        public static HashSet<string> ReferenceParentParameterNames { get; set; }
    }
}
