﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public partial class FilePathParameterEditPanel : UserControl, IParameterEditPanel
    {
        private Component[] targetComponents = null;
        private string name = null;

        public event ValueChangingEventHandler ValueChanging;
        public event ValueChangedEventHandler ValueChanged;

        private bool suspendEvent = false;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FilePathParameterEditPanel()
        {
            InitializeComponent();

            //this.textBox.ValueChanged += OnFinished;
            this.textBox.Leave += OnLeave;
        }

        /// <summary>
        ///
        /// </summary>
        public Component[] Components
        {
            get
            {
                return this.targetComponents;
            }
            set
            {
                this.targetComponents = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string ParameterName
        {
            set
            {
                this.name = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string Label
        {
            set
            {
                this.label.Text = value;
            }
        }
#if false
        /// <summary>
        ///
        /// </summary>
        public float Minimum
        {
            get
            {
                return Convert.ToSingle( this.trackBar.Minimum);
            }
            set
            {
                Decimal decimalValue = Convert.ToDecimal( value);
                this.trackBar.Minimum = decimalValue;
                this.textBox.Minimum = decimalValue;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public float Maximum
        {
            get
            {
                return Convert.ToSingle( this.trackBar.Maximum);
            }
            set
            {
                Decimal decimalValue = Convert.ToDecimal( value);
                this.trackBar.Maximum = decimalValue;
                this.textBox.Maximum = decimalValue;
            }
        }
#endif
        /// <summary>
        ///
        /// </summary>
        public string Value
        {
            get
            {
                //return Convert.ToSingle( this.trackBar.Value);
                return textBox.Text;
            }
            set
            {
                SetValueToUI(value);
            }
        }

        /// <summary>
        ///
        /// </summary>
        public void UpdateUI()
        {
            if (this.targetComponents == null)
            {
                return;
            }

            if (this.targetComponents.Length == 1)
            {
                Component component = this.targetComponents[0];
                IParameterValue value = component.Parameters[this.name];
                SetValueToUI(Convert.ToString(value.Value));
            }
            else
            {
                // 未実装
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void SetValueToUI(string value)
        {
            try
            {
                this.suspendEvent = true;

                //this.trackBar.Value = (Decimal)value;
                this.textBox.Text = value;
            }
            finally
            {
                this.suspendEvent = false;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private bool IsValueChanged(string value)
        {
            if (this.targetComponents.Length == 1)
            {
                Component component = this.targetComponents[0];
                string origValue = (string)component.Parameters[this.name].Value;
                return origValue != value ? true : false;
            }
            else
            {
                // 未実装
                return false;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void SetValue(string value)
        {
            // 同じ値ならば再設定を行いません。
            if (IsValueChanged(value) == false)
            {
                return;
            }

            //
            SetValueToUI(value);

            if (ValueChanged != null)
            {
                ValueChanged(this, new FilePathValueChangedEventArgs
                              (this.targetComponents, this.name, value));
            }
        }

#if false
        /// <summary>
        ///
        /// </summary>
        private void SetValueByText( string text)
        {
            if( String.IsNullOrEmpty( text) != false )
            {
                return;
            }

            try
            {
                float value = float.Parse( text);
                if( value < Minimum ||
                    value > Maximum )
                {
                    return;
                }

                SetValue( value);
            }
            catch
            {
            }
        }
#endif
#if false
        /// <summary>
        ///
        /// </summary>
        private void OnFinished( object sender, ValueChangedEventArgs e)
        {
            if( this.suspendEvent != false )
            {
                return;
            }

            NNumericUpDown control = sender as NNumericUpDown;
            Debug.Assert( control != null, "Sender is not NNumericUpDown control");
            SetValue( (string)control.Value);
        }
#endif
        /// <summary>
        ///
        /// </summary>
        private void OnLeave(object sender, EventArgs e)
        {
            if (this.suspendEvent != false)
            {
                return;
            }
#if false
            NNumericUpDown control = sender as NNumericUpDown;
            Debug.Assert( control != null, "Sender is not NNumericUpDown control");
            SetValue( (string)control.Value);
#endif
        }

        /// <summary>
        ///
        /// </summary>
        private void OnValueChanged(object sender, ValueChangedEventArgs e)
        {
            if (this.suspendEvent != false)
            {
                return;
            }

            NTrackBar trackBar = sender as NTrackBar;
            string value = Convert.ToString(trackBar.Value);

            if (trackBar.IsDragging != false)
            {
                SetValueToUI(value);

                if (ValueChanging != null)
                {
                    ValueChanging(this, new FilePathValueChangingEventArgs
                                   (this.targetComponents, this.name, value));
                }
            }
            else
            {
                SetValue(value);
            }
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class FilePathValueChangeEventArgs : ValueChangeEventArgs
    {
        public FilePathValueChangeEventArgs(Component[] components, string name, object value) :
            base(components, name, value)
        {
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class FilePathValueChangingEventArgs : FilePathValueChangeEventArgs
    {
        /// <summary>
        ///
        /// </summary>
        public FilePathValueChangingEventArgs(Component[] components, string name, string value) :
            base(components, name, value)
        {
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class FilePathValueChangedEventArgs : FilePathValueChangeEventArgs
    {
        /// <summary>
        ///
        /// </summary>
        public FilePathValueChangedEventArgs(Component[] components, string name, string value) :
            base(components, name, value)
        {
        }
    }
}
