﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Operations;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Framework.Commands;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    ///
    /// </summary>
    public partial class BoolParameterEditPanel : UserControl, IParameterEditPanel
    {
        private Component[] targetComponents = null;
        private string name = null;

        public event ValueChangedEventHandler ValueChanged;

        private bool suspendEvent = false;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BoolParameterEditPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        ///
        /// </summary>
        public Component[] Components
        {
            get
            {
                return this.targetComponents;
            }
            set
            {
                this.targetComponents = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string ParameterName
        {
            set
            {
                this.name = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public string Label
        {
            set
            {
                this.checkBox.Text = value;
            }
        }

        /// <summary>
        ///
        /// </summary>
        public bool Value
        {
            get
            {
                return this.checkBox.Checked;
            }
            set
            {
                SetValueToUI(value);
            }
        }

        /// <summary>
        ///
        /// </summary>
        public void UpdateUI()
        {
            if (this.targetComponents == null)
            {
                return;
            }

            if (this.targetComponents.Length == 1)
            {
                Component component = this.targetComponents[0];
                IParameterValue value = component.Parameters[this.name];
                SetValueToUI((bool)value.Value);
            }
            else
            {
                // 未実装
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void SetValueToUI(bool value)
        {
            try
            {
                this.suspendEvent = true;

                this.checkBox.Checked = value;
            }
            finally
            {
                this.suspendEvent = false;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private bool IsValueChanged(bool value)
        {
            if (this.targetComponents.Length == 1)
            {
                Component component = this.targetComponents[0];
                bool origValue = (bool)component.Parameters[this.name].Value;
                return origValue != value ? true : false;
            }
            else
            {
                // 未実装
                return false;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void SetValue(bool value)
        {
            // 同じ値ならば再設定を行いません。
            if (IsValueChanged(value) == false)
            {
                return;
            }

            //
            SetValueToUI(value);

            if (ValueChanged != null)
            {
                ValueChanged(this, new BoolValueChangedEventArgs
                              (this.targetComponents, this.name, value));
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void OnCheckedChanged(object sender, EventArgs e)
        {
            if (this.suspendEvent != false)
            {
                return;
            }

            CheckBox checkBox = sender as CheckBox;
            bool value = checkBox.Checked;
            SetValue(value);
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class BoolValueChangeEventArgs : ValueChangeEventArgs
    {
        public BoolValueChangeEventArgs(Component[] components, string name, object value) :
            base(components, name, value)
        {
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class BoolValueChangingEventArgs : BoolValueChangeEventArgs
    {
        /// <summary>
        ///
        /// </summary>
        public BoolValueChangingEventArgs(Component[] components, string name, bool value) :
            base(components, name, value)
        {
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class BoolValueChangedEventArgs : BoolValueChangeEventArgs
    {
        /// <summary>
        ///
        /// </summary>
        public BoolValueChangedEventArgs(Component[] components, string name, bool value) :
            base(components, name, value)
        {
        }
    }
}
