﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Conversion.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.Projects;

#if DEBUG

    internal class FormsApplicationMock : FormsApplication
    {
        /// <summary>
        /// コンストラクタ。
        /// Singleton のため外部からの生成は禁止されています。
        /// </summary>
        private FormsApplicationMock()
            : base(
            new ApplicationTraits()
            {
                ConversionTraits = new SoundProjectConversionTraits(true, 260),
                IntermediateOutputTraits = new SoundIntermediateOutputTraits(),
                BinaryOutputTraits = new SoundBinaryOutputTraits(),
            }
            )
        {
        }

        public static void InitializeForFormDesigner()
        {
            if ( null != FormsApplicationMock.Instance ) { return; }
            new FormsApplicationMock();
        }

        /// <summary>
        /// サービスのインスタンスを作成します。
        /// </summary>
        /// <param name="serviceType">作成するサービスの種類。</param>
        /// <returns>サービスのインスタンス。</returns>
        protected override object CreateService( Type serviceType )
        {
            if ( serviceType == typeof( UIServiceBase ) ) {
                return new FormsUIService();
            }

            return base.CreateService( serviceType );
        }

        /// <summary>
        /// アプリケーション設定クラスを作成します。
        /// </summary>
        /// <returns>作成した AppConfiguration。</returns>
        protected override AppConfiguration CreateAppConfiguration()
        {
            return new AppConfigurationMock();
        }

        /// <summary>
        /// プロジェクト設定クラスを作成します。
        /// </summary>
        /// <returns>作成した SoundProjectConfiguration。</returns>
        protected override SoundProjectConfiguration CreateProjectConfiguration()
        {
            return new SoundProjectConfigurationMock();
        }

        /// <summary>
        /// カラムプリセット設定クラスを作成します。
        /// </summary>
        /// <returns>作成した PresetListColumnsConfiguration。</returns>
        protected override PresetListColumnsConfiguration CreatePresetListColumnsConfiguration()
        {
            return new PresetListColumnsConfiguration();
        }

        /// <summary>
        /// ブックマーク設定クラスを作成します。
        /// </summary>
        /// <returns>作成した BookmarkConfiguration。</returns>
        protected override BookmarkConfiguration CreateBookmarkConfiguration()
        {
            return new BookmarkConfiguration();
        }

        /// <summary>
        /// ドキュメントサービス特性を生成します。
        /// </summary>
        protected override IDocumentServiceTraits CreateDocumentServiceTraits()
        {
            return new DocumentServiceTraits();
        }

        /// <summary>
        /// ドキュメントインポートサービス特性を生成します。
        /// </summary>
        protected override DocumentImportServiceTraits CreateDocumentImportServiceTraits()
        {
            return new DocumentImportServiceTraits();
        }

        /// <summary>
        /// アプリケーションを実行します。
        /// </summary>
        /// <param name="args">コマンドライン引数。</param>
        protected override void RunApplication(string[] args)
        {
        }
    }

#endif
}
