﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Documents;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundMaker.Framework.Utilities;

    /// <summary>
    /// ProjectCreatePageSpecifySoundSet の概要の説明です。
    /// </summary>
    public class ProjectCreatePageSpecifySoundSet : ProjectCreatePage, IWizardPage
    {
        private System.Windows.Forms.Button button_ReferenceSoundSet;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.TextBox textBox_FilePath;

        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ProjectCreatePageSpecifySoundSet()
        {
            InitializeComponent();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        void IWizardPage.PreShow()
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        bool IWizardPage.OnBack()
        {
            return true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        string IWizardPage.OnNext()
        {
            if (InspectFilePath() == false)
            {
                return null;
            }
            return "Finish";
        }

        ///--------------------------------
        /// <summary>
        /// パスの検査
        /// </summary>
        private bool InspectFilePath()
        {
            string filePath = textBox_FilePath.Text;

            if (filePath == String.Empty)
            {
                ShowError(textBox_FilePath, MessageResource.Message_InputPath);
                return false;
            }

            if (File.Exists(filePath) == false)
            {
                ShowError(textBox_FilePath, MessageResource.Message_FileNotFound);
                return false;
            }

            // プロジェクトファイルの存在するディレクトリ外なのか調べます。
            ProjectCreateWizard wizard = this.ParentForm as ProjectCreateWizard;
            string projectFilePath = wizard.ProjectFilePath;
            if (ProjectFilePathUtility.ConfirmFilePath(projectFilePath, filePath) == false)
            {
                return false;
            }

            // 指定された既存のサウンドセットファイル及び参照バンクファイルのバージョンが古いか調べます。
            this.OldVersionFilePaths = null;
            List<DocumentReference> docRefList = null;
            try
            {
                List<string> newVersionFiles = new List<string>();
                List<string> oldVersionFiles = new List<string>();

                docRefList = FileVersionUtility.GetDifferentVersionFilesWithSoundSetFile(filePath, ref newVersionFiles, ref oldVersionFiles);
                if (newVersionFiles.Any() == true)
                {
                    MessageBox.Show(MessageResource.Message_UnsupportedNewFileVersion, MessageResource.Message_Warning, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                    return false;
                }
                else if (oldVersionFiles.Any() == true)
                {
                    if (MessageBox.Show(MessageResource.Message_UnsupportedOldFileVersion, MessageResource.Message_Confirm, MessageBoxButtons.OKCancel, MessageBoxIcon.Warning) == DialogResult.OK)
                    {
                        this.OldVersionFilePaths = oldVersionFiles.ToArray();
                    }
                    else
                    {
                        return false; // キャンセル
                    }
                }
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
                return false;
            }
            finally
            {
                if (docRefList != null)
                {
                    docRefList.ForEach(d => d.Close());
                }
            }

            return true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        bool IWizardPage.OnFinish() { return false; }
        bool IWizardPage.QueryFinishPage() { return false; }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string SoundSetFilePath
        {
            get { return textBox_FilePath.Text; }
        }



        // <summary>
        // 古いバージョンのファイル群の取得
        // </summary>
        public string[] OldVersionFilePaths
        {
            get; private set;
        }


        ///--------------------------------
        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コンポーネント デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ProjectCreatePageSpecifySoundSet));
            this.button_ReferenceSoundSet = new System.Windows.Forms.Button();
            this.label3 = new System.Windows.Forms.Label();
            this.textBox_FilePath = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // button_ReferenceSoundSet
            //
            resources.ApplyResources(this.button_ReferenceSoundSet, "button_ReferenceSoundSet");
            this.button_ReferenceSoundSet.Name = "button_ReferenceSoundSet";
            this.button_ReferenceSoundSet.Click += new System.EventHandler(this.OnReferenceSoundSet);
            //
            // label3
            //
            resources.ApplyResources(this.label3, "label3");
            this.label3.Name = "label3";
            //
            // textBox_FilePath
            //
            resources.ApplyResources(this.textBox_FilePath, "textBox_FilePath");
            this.textBox_FilePath.Name = "textBox_FilePath";
            //
            // label1
            //
            resources.ApplyResources(this.label1, "label1");
            this.label1.Name = "label1";
            //
            // ProjectCreatePageSpecifySoundSet
            //
            this.Controls.Add(this.label1);
            this.Controls.Add(this.button_ReferenceSoundSet);
            this.Controls.Add(this.label3);
            this.Controls.Add(this.textBox_FilePath);
            this.Name = "ProjectCreatePageSpecifySoundSet";
            resources.ApplyResources(this, "$this");
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion


        /// <summary>
        ///
        /// </summary>
        private void OnReferenceSoundSet(object sender, System.EventArgs e)
        {
            string filePath = null;

            if ((filePath = SoundSetFileQuester.QueryLoad(false)) != null)
            {
                textBox_FilePath.Text = filePath;
            }
        }
    }
}
