﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Projects;

    public partial class CreateWaveArchiveDialog : CreateSoundSetItemDialog
    {
        private readonly WaveArchiveBase _waveArchive = ApplicationBase.Instance.CreateComponentService.Create<WaveArchiveBase>();

        public CreateWaveArchiveDialog(SoundProjectService projectService) : base(projectService)
        {
            InitializeComponent();

            //
            SetUniqueNameToTextBox(textBoxName, projectService.Project,
                                    ProjectService.ComponentDictionary,
                                    ProjectService.Project.WaveArchiveNamePrefix);

            this.LoadType = _waveArchive.LoadType;
        }

        private string Label
        {
            get { return this.textBoxName.Text; }
        }

        private WaveArchiveLoadType LoadType
        {
            get
            {
                return this.checkBoxLoadType.Checked == true ? WaveArchiveLoadType.Individual : WaveArchiveLoadType.Whole;
            }
            set
            {
                switch (value)
                {
                    case WaveArchiveLoadType.Individual:
                        this.checkBoxLoadType.Checked = true;
                        break;

                    case WaveArchiveLoadType.Whole:
                        this.checkBoxLoadType.Checked = false;
                        break;
                }
            }
        }

        public WaveArchiveBase WaveArchive
        {
            get
            {
                _waveArchive.LoadType = this.LoadType;
                _waveArchive.Name = this.Label;

                return _waveArchive;
            }
        }

        protected override bool CanCreate
        {
            get
            {
                try
                {
                    if (
                        ValidateName(textBoxName.Text, textBoxName) &&
                        ValidateParameter(
                                          _waveArchive,
                                          ProjectParameterNames.WaveArchive.LoadType,
                                          this.LoadType,
                                          checkBoxLoadType
                                          )
                        )
                    {
                        return true;
                    }
                }
                catch { }
                return false;
            }
        }
    }
}
