﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Resources;
using NintendoWare.SoundMaker.Framework.Utilities;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public partial class CreateSoundDialog : CreateSoundSetItemDialog
    {
        private readonly PlayerBase _defaultPlayer;
        private SoundSetDocument targetSoundSetDocument = null;

        protected CreateSoundDialog()
        {
            InitializeComponent();
        }

        protected CreateSoundDialog(SoundProjectService projectService, SoundSetDocument targetSoundSetDocument, string defaultPlayerName)
            : base(projectService)
        {
            if (null == defaultPlayerName) { throw new ArgumentNullException("defaultPlayerName"); }
            _defaultPlayer = ApplicationBase.Instance.CreateComponentService.Create<PlayerBase>();
            _defaultPlayer.Name = defaultPlayerName;
            this.targetSoundSetDocument = targetSoundSetDocument;

            InitializeComponent();
        }

        protected ComponentUIControlItem[] BankControlItems
        {
            get
            {
                var soundSet = this.targetSoundSetDocument.SoundSet;
                if (AddonSoundArchiveUtility.IsItemInAddonSoundArchive(soundSet) == true)
                {
                    return SoundSetUtility.GetSoundSetBanks(AddonSoundArchiveUtility.GetMainSoundSets().Concat(new[] { soundSet }))
                        .Select(b => new ComponentUIControlItem(b))
                        .ToArray();
                }
                else
                {
                    return SoundSetUtility.GetSoundSetBanks(AddonSoundArchiveUtility.GetMainSoundSets())
                        .Select(b => new ComponentUIControlItem(b))
                        .ToArray();
                }
            }
        }

        protected ComponentUIControlItem[] PlayerControlItems
        {
            get
            {
                var controlItems = new List<ComponentUIControlItem>();

                controlItems.AddRange(SoundSetUtility.GetPlayers(AddonSoundArchiveUtility.GetMainSoundSets())
                    .Select(p => new ComponentUIControlItem(p)));

                if (controlItems.Count == 0)
                {
                    controlItems.Add(new ComponentUIControlItem(_defaultPlayer));
                }

                return controlItems.ToArray();
            }
        }
    }
}
