﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Core;
using NintendoWare.SoundFoundation.Core.Parameters;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Resources;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// CreateProjectItemDialog の基本クラス
    /// </summary>
    public partial class CreateProjectItemDialog : CreateItemDialog
    {
        private SoundProjectService _projectService;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public CreateProjectItemDialog()
        {
            InitializeComponent();
        }

        protected CreateProjectItemDialog(SoundProjectService projectService)
        {
            if (null == projectService) { throw new ArgumentNullException("projectService"); }
            _projectService = projectService;

            InitializeComponent();
        }

        protected SoundProjectService ProjectService
        {
            get { return _projectService; }
        }

        /// <summary>
        /// 名前の検証
        /// </summary>
        protected bool ValidateName(string name, Control control)
        {
            return base.ValidateName(ProjectService, name, control);
        }

        /// <summary>
        /// パラメータの検証
        /// </summary>
        protected bool ValidateParameter(Component item, string parameterName, object value, Control control)
        {
            if (null == item) { throw new ArgumentNullException("sound"); }
            if (null == parameterName) { throw new ArgumentNullException("parameterName"); }
            if (null == value) { throw new ArgumentNullException("value"); }
            if (null == control) { throw new ArgumentNullException("control"); }

            ValidationResult result = item.Parameters[parameterName].ValidateValue(value);

            if (!result.IsValid)
            {
                ShowError(control, result.ToString());
                return false;
            }

            HideError(control);
            return true;
        }

        ///--------------------------------
        protected bool ValidateIntParameter(Component item, string parameterName, string text, Control control)
        {
            if (null == item) { throw new ArgumentNullException("sound"); }
            if (null == parameterName) { throw new ArgumentNullException("parameterName"); }
            if (null == text) { throw new ArgumentNullException("text"); }
            if (null == control) { throw new ArgumentNullException("control"); }

            string errorMessage = null;
            int value = 0;

            try
            {
                value = int.Parse(text);
                ValidationResult result = item.Parameters[parameterName].ValidateValue(value);

                if (result.IsValid != false)
                {
                    HideError(control);
                    return true;
                }

                errorMessage = result.ToString();
            }
            catch (OverflowException)
            {
                IntParameterValue intValue = item.Parameters[parameterName] as IntParameterValue;
                errorMessage = (null != intValue) ?
                                    string.Format(MessageResource.Message_OverflowNumber,
                                                   intValue.MinValue, intValue.MaxValue) :
                                    MessageResource.Message_PleaseInputNumericalValue;
            }
            catch
            {
                errorMessage = MessageResource.Message_PleaseInputNumericalValue;
            }

            ShowError(control, errorMessage);

            return false;
        }
    }
}
