﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System.Linq;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Projects;

    public partial class SoundSetSelectDialog : Form
    {
        private SoundProjectService projectService = null;
        private string[] selectedSoundSetNames = null;

        public SoundSetSelectDialog(SoundProjectService projectService, string[] selectedSoundSetNames)
        {
            InitializeComponent();

            this.projectService = projectService;
            this.selectedSoundSetNames = selectedSoundSetNames;

            UpdateListView();
            ApplyToListViewChecked(this.selectedSoundSetNames);
        }

        /// <summary>
        ///
        /// </summary>
        public SoundSet[] SelectedSoundSets
        {
            get
            {
                SoundSet[] soundSets = this.lvw_SoundSet.Items
                    .Cast<ListViewItem>()
                    .Where(i => i.Checked != false)
                    .Select(i => i.Tag)
                    .Cast<SoundSet>()
                    .ToArray();
                return soundSets;
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void UpdateListView()
        {
            foreach (SoundSetDocument soundSetDocument in this.projectService.SoundSetDocuments)
            {
                SoundSet soundSet = soundSetDocument.SoundSet;

                ListViewItem item = new ListViewItem();
                item.Name = soundSet.Name;
                item.Text = soundSet.Name;
                item.Tag = soundSet;

                this.lvw_SoundSet.Items.Add(item);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void ApplyToListViewChecked(string[] names)
        {
            foreach (string name in names)
            {
                foreach (ListViewItem item in this.lvw_SoundSet.Items.Find(name, false))
                {
                    item.Checked = true;
                }
            }
        }
    }
}
