﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class SelectReconvertDialog : Form
    {
        public SelectReconvertDialog()
        {
            InitializeComponent();
            this.UpdateDialog();
        }

        public bool CheckStreamSound
        {
            get { return this.StreamSoundCheckBox.Checked; }
            set { this.StreamSoundCheckBox.Checked = value; }
        }

        public bool CheckWaveSoundSet
        {
            get { return this.WaveSoundSetCheckBox.Checked; }
            set { this.WaveSoundSetCheckBox.Checked = value; }
        }

        public bool CheckSequenceSound
        {
            get { return this.SequenceSoundCheckBox.Checked; }
            set { this.SequenceSoundCheckBox.Checked = value; }
        }

        public bool CheckBank
        {
            get { return this.BankCheckBox.Checked; }
            set { this.BankCheckBox.Checked = value; }
        }

        private void OnOKClick(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }

        private void OnCheckedChanged(object sender, EventArgs e)
        {
            this.UpdateDialog();
        }

        private void UpdateDialog()
        {
            this.OKButton.Enabled = (this.StreamSoundCheckBox.Checked == true ||
                                     this.WaveSoundSetCheckBox.Checked == true ||
                                     this.SequenceSoundCheckBox.Checked == true ||
                                     this.BankCheckBox.Checked == true);
        }
    }
}
