﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.IO;
    using System.Windows.Forms;

    public class ReferenceFileFinder
    {
        private IWin32Window owner;

        public ReferenceFileFinder() : this(null)
        {
        }

        public ReferenceFileFinder(IWin32Window owner)
        {
            this.owner = owner;

            this.Text = string.Empty;
            this.IsIgnoreAll = false;
            this.IsFindAll = false;
            this.FindTargetDiretory = null;
        }

        public string Text { get; set; }

        public bool IsIgnoreAll { get; set; }

        public bool IsFindAll { get; set; }

        public string FindTargetDiretory { get; set; }

        public string Validate(string filePath)
        {
            if (null == filePath) { throw new ArgumentNullException("filePath"); }

            string returnFilePath = filePath;

            if (!this.IsFindAll)
            {
                this.FindTargetDiretory = null;
            }

            while (!this.IsIgnoreAll)
            {
                if (null != returnFilePath)
                {
                    if (File.Exists(returnFilePath)) { break; }
                }

                if (null != this.FindTargetDiretory)
                {
                    returnFilePath = FindFile(this.FindTargetDiretory, filePath);

                    if (null == returnFilePath)
                    {
                        this.FindTargetDiretory = null;
                    }
                    continue;
                }

                this.IsFindAll = false;

                ReferenceFileFindDialog dialog = new ReferenceFileFindDialog(this.Text, filePath)
                {
                    DoIgnoreAll = this.IsIgnoreAll,
                };

                dialog.ShowDialog(this.owner);

                switch (dialog.Action)
                {
                    case ReferenceFileFindDialog.Actions.SpecifyFilePath:
                        returnFilePath = dialog.FilePath;
                        break;

                    case ReferenceFileFindDialog.Actions.SpecifyDirectory:
                        this.IsFindAll = dialog.DoSpecifyFindDirectory;
                        this.FindTargetDiretory = dialog.Directory;
                        continue;

                    case ReferenceFileFindDialog.Actions.Ignore:
                        this.IsIgnoreAll = dialog.DoIgnoreAll;
                        return null;
                }
            }

            return returnFilePath;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private string FindFile(string directory, string filePath)
        {
            try
            {
                DirectoryInfo directoryInfo = new DirectoryInfo(directory);
                string fileName = Path.GetFileName(filePath);
                return FindFile(directoryInfo, fileName);
            }

            catch { return null; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private string FindFile(DirectoryInfo info, string fileName)
        {
            DirectoryInfo[] directoryInfos = null;
            FileInfo[] fileInfos = null;
            string filePath = null;

            if (info.Exists == false)
            {
                return null;
            }

            //
            fileInfos = info.GetFiles();
            foreach (FileInfo fileInfo in fileInfos)
            {
                if (fileInfo.Name == fileName)
                {
                    return fileInfo.FullName;
                }
            }

            //
            directoryInfos = info.GetDirectories();
            foreach (DirectoryInfo directoryInfo in directoryInfos)
            {
                if ((filePath = FindFile(directoryInfo, fileName)) != null)
                {
                    return filePath;
                }
            }

            return null;
        }
    }
}
