﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using NintendoWare.SoundFoundation.Conversion;

    public partial class ConvertWaitingDialog : Form
    {
        private ISoundProjectConvertService convertService = null;

        /// <summary>
        ///
        /// </summary>
        public ConvertWaitingDialog(ISoundProjectConvertService convertService)
        {
            InitializeComponent();

            this.convertService = convertService;
            this.timer.Enabled = true;
        }

        /// <summary>
        ///
        /// </summary>
        private void OnClick_Cancel(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        /// <summary>
        ///
        /// </summary>
        private void OnTick(object sender, EventArgs e)
        {
            Debug.Assert(this.convertService != null, "ConvertService is null");
            if (this.convertService.IsConverting == false)
            {
                this.timer.Enabled = false;
                DialogResult = DialogResult.OK;
            }
        }
    }
}
