﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    [CommandKeyProcessable]
    public partial class DockingToolWindow : DockingForm
    {
        public DockingToolWindow(Form owner, IDockingPage page)
            : base(owner, page)
        {
            InitializeComponent();
        }

        protected override void OnDragEnter(DragEventArgs drgevent)
        {
            if (FormsApplication.Instance.UIService.MainWindow.CanDropFiles(drgevent))
            {
                drgevent.Effect = DragDropEffects.Copy;
                return;
            }
        }

        protected override void OnDragDrop(DragEventArgs drgevent)
        {
            if (!drgevent.Data.GetDataPresent(DataFormats.FileDrop)) { return; }

            string[] filePaths = (string[])drgevent.Data.GetData(DataFormats.FileDrop);
            Array.Sort(filePaths);

            FormsApplication.Instance.UIService.MainWindow.DropFiles(filePaths);
        }
    }
}
