﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public partial class DockingToolContainer : DockingFormContainer
    {
        public DockingToolContainer()
        {
            InitializeComponent();
        }

        protected override DockingForm CreateDockingForm(Form owner, IDockingPage page)
        {
            return new DockingToolWindow(owner, page);
        }

        protected override DockingFormContainerTabControl CreateTabControl()
        {
            return new TabControl();
        }

        private class TabControl : DockingFormContainerTabControl
        {
            protected override void OnDragEnter(DragEventArgs drgevent)
            {
                if (FormsApplication.Instance.UIService.MainWindow.CanDropFiles(drgevent))
                {
                    drgevent.Effect = DragDropEffects.Copy;
                    return;
                }

                base.OnDragEnter(drgevent);
            }

            protected override void OnDragOver(DragEventArgs drgevent)
            {
                if (FormsApplication.Instance.UIService.MainWindow.CanDropFiles(drgevent))
                {
                    drgevent.Effect = DragDropEffects.Copy;
                    return;
                }

                base.OnDragOver(drgevent);
            }

            protected override void OnDragDrop(DragEventArgs drgevent)
            {
                if (FormsApplication.Instance.UIService.MainWindow.CanDropFiles(drgevent))
                {
                    string[] filePaths = (string[])drgevent.Data.GetData(DataFormats.FileDrop, false);
                    FormsApplication.Instance.UIService.MainWindow.DropFiles(filePaths);
                    return;
                }

                base.OnDragDrop(drgevent);
            }
        }
    }
}
