﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Diagnostics;
    using System.Drawing;
    using System.Linq;
    using System.Reflection;
    using System.Text;
    using System.Windows.Forms;

    public partial class SplashWindow : Form
    {
        private static SplashWindow splashWindow = null;

        /// <summary>
        ///
        /// </summary>
        public static Bitmap BackgroundBitmapImage
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public static FileVersionInfo VersionInfo
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public static string OtherAddedInfomation
        {
            get;
            set;
        }

        /// <summary>
        /// ビルド番号表示の有効性を取得、設定します。
        /// </summary>
        public static bool EnabledBuildNumber
        {
            get;
            set;
        }

        /// <summary>
        ///
        /// </summary>
        public static void ShowWindow()
        {
            if (splashWindow != null)
            {
                return;
            }

            Application.Idle += OnApplicationIdle;

            splashWindow = new SplashWindow();
            splashWindow.SplashMode = true;
            splashWindow.Show();
        }

        /// <summary>
        ///
        /// </summary>
        public static void ShowDialogCloseIfTouched()
        {
            if (splashWindow != null)
            {
                return;
            }

            splashWindow = new SplashWindow();
            splashWindow.SplashMode = false;
            splashWindow.ShowDialog();
        }

        /// <summary>
        ///
        /// </summary>
        public static void SetOwner(Form ownerForm)
        {
            Debug.Assert(splashWindow != null, "Not created splash window");
            splashWindow.Owner = ownerForm;
        }

        ///
        private bool splashMode = false;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SplashWindow()
        {
            InitializeComponent();

            this.lblVersion.Visible = false;
            this.lblCopyright.Visible = false;
        }

        /// <summary>
        ///
        /// </summary>
        public bool SplashMode
        {
            get
            {
                return this.splashMode;
            }
            set
            {
                this.splashMode = value;
                if (value == true)
                {
                    splashWindow.button_CopyInformation.Visible = false;
                    splashWindow.button_OK.Visible = false;
                }
                else
                {
                    splashWindow.button_CopyInformation.Visible = true;
                    splashWindow.button_OK.Visible = true;
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnActivated(EventArgs e)
        {
            base.OnActivated(e);

            //
            FileVersionInfo info = VersionInfo;
            string versionText = String.Empty;
            string copyrightText = String.Empty;
            if (info != null)
            {
                versionText = String.Format("Version {0}.{1}.{2}",
                                             info.ProductMajorPart,
                                             info.ProductMinorPart,
                                             info.ProductBuildPart);
                if (EnabledBuildNumber == true)
                {
                    versionText += String.Format("  Build {0}", info.ProductPrivatePart);
                }

                if (string.IsNullOrEmpty(OtherAddedInfomation) == false)
                {
                    versionText += "\n" + OtherAddedInfomation;
                }

                copyrightText = info.LegalCopyright;
            }
            this.lblVersion.Text = versionText;
            this.lblCopyright.Text = copyrightText;

            //
            if (BackgroundBitmapImage != null)
            {
                int width = BackgroundBitmapImage.Width;
                int height = BackgroundBitmapImage.Height;

                if (this.splashMode == false)
                {
                    height += button_OK.Height + 12;

                    // 広げた部分を背景色を画像の色に合わせます。(座標(0, 0)の色)
                    //Color color = BackgroundBitmapImage.GetPixel( 0, 0);
                    //BackColor = color;
                }

                this.Bounds = new Rectangle(this.Bounds.X, this.Bounds.Y, width, height);
            }

            // 直に表示されるようにする為に強制的に描画を行います。
            this.Update();
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics gc = e.Graphics;
            Brush brush = new SolidBrush(lblVersion.ForeColor);
            StringFormat format = new StringFormat();
            format.Alignment = StringAlignment.Far;
            format.LineAlignment = StringAlignment.Center;

            gc.DrawImage(BackgroundBitmapImage, 0, 0, BackgroundBitmapImage.Width, BackgroundBitmapImage.Height);
            gc.DrawString(this.lblVersion.Text, this.lblVersion.Font,
                           brush, lblVersion.Bounds, format);
            gc.DrawString(this.lblCopyright.Text, this.lblCopyright.Font,
                           brush, lblCopyright.Bounds, format);

            //
            gc.DrawRectangle(new Pen(SystemColors.ControlDarkDark),
                              0, 0, this.Bounds.Width - 1, this.Bounds.Height - 1);
        }

        /// <summary>
        ///
        /// </summary>
        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);

            splashWindow = null;
        }

        /// <summary>
        ///
        /// </summary>
        private static void OnApplicationIdle(object sender, EventArgs e)
        {
            if (splashWindow != null && splashWindow.IsDisposed == false)
            {
                splashWindow.Close();
            }
            splashWindow = null;
            Application.Idle -= OnApplicationIdle;
        }

        /// <summary>
        ///
        /// </summary>
        private void OnCopyInformation(object sender, EventArgs e)
        {
            FileVersionInfo info = VersionInfo;
            string text = String.Format("{0}\r\n{1}\r\n",
                                         info.ProductName,
                                         this.lblVersion.Text);
            Clipboard.SetDataObject(text, true);
        }
    }
}
