﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Documents;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Commands;
using NintendoWare.SoundMaker.Framework.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    /// <summary>
    /// 新しいサウンドセットを追加します。
    /// </summary>
    public class QueryAndAddNewSoundSetHandler : AddSoundSetHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        public QueryAndAddNewSoundSetHandler(IQueryCommandParameter queryParameter)
            : base(ProjectCommands.AddNewSoundSet.ID, false, queryParameter) { }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            SoundProjectService targetProjectService = GetTargetComponentService(parameters) as SoundProjectService;

            CreateSoundSetDialog form = new CreateSoundSetDialog(Application.ProjectService);
            if (form.ShowDialog() != DialogResult.OK) { return false; }

            DocumentReference documentRef = form.CreateSoundSetDocument();
            if (documentRef == null)
            {
                return false;
            }

            var targetComponent = GetInsertParentComponent(parameters);

            try
            {
                return Execute(targetProjectService, documentRef, targetComponent);
            }
            finally
            {
                documentRef.Close();
            }
        }
    }
}
