﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.CommandHandlers;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// "切り取り"ハンドラ
    /// </summary>
    public class SoundSetPanelCutHandler : CutHandler
    {
        private CaretItemSetter _CaretItemSetter = new CaretItemSetter();

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundSetPanelCutHandler(IQueryCommandParameter queryParameter)
            : base(queryParameter)
        {
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);
            if (components == null || components.Length == 0) { return CommandStatus.SupportedAndVisible; }

            if (components[0].Parent is StreamSoundBase &&
                components[0].Parent.Children.Count == components.Length)
            {
                return CommandStatus.SupportedAndVisible;
            }

            return CommandStatus.SupportedAndEnabledAndVisible;
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            _CaretItemSetter.PreserveNextItem(parameters);

            if (base.ExecuteInternal(command, parameters) == false)
            {
                return false;
            }

            _CaretItemSetter.SetCaretByPreservedItem(parameters);
            return true;
        }
    }
}

