﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Utilities
{
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Projects;

    public static class FileVersionUtility
    {
        private static DocumentService DocumentService
        {
            get { return CoreServicesProvider.Instance?.DocumentService; }
        }

        public static List<DocumentReference> GetDifferentVersionFilesWithProjectFile(string spjFilePath, ref List<string> newVersionFiles, ref List<string> oldVersionFiles)
        {
            List<DocumentReference> docRefList = new List<DocumentReference>();
            DocumentService documentService = DocumentService;

            if (documentService == null)
            {
                return docRefList;
            }

            GetDifferentVersionFile(spjFilePath, ref newVersionFiles, ref oldVersionFiles);
            if (0 < newVersionFiles.Count)
            {
                return docRefList;
            }
            else
            {
                DocumentReference documentRef = documentService.OpenDocument(new FileResource(spjFilePath));
                if (documentRef == null ||
                    documentRef.Document is SoundProjectDocument == false)
                {
                    return docRefList;
                }

                docRefList.Add(documentRef);

                SoundProjectDocument document = documentRef.Document as SoundProjectDocument;
                foreach (string targetFilePath in document.Project.GetProjectSoundSetComponentFilePaths())
                {
                    docRefList.AddRange(GetDifferentVersionFilesWithSoundSetFile(targetFilePath, ref newVersionFiles, ref oldVersionFiles));
                }
            }

            return docRefList;
        }

        public static List<DocumentReference> GetDifferentVersionFilesWithSoundSetFile(string sstFilePath, ref List<string> newVersionFiles, ref List<string> oldVersionFiles)
        {
            DocumentService documentService = DocumentService;
            List<DocumentReference> docRefList = new List<DocumentReference>();

            GetDifferentVersionFile(sstFilePath, ref newVersionFiles, ref oldVersionFiles);

            if (0 < newVersionFiles.Count)
            {
                return docRefList;
            }

            DocumentReference documentRef = documentService.OpenDocument(new FileResource(sstFilePath));
            {
                if (documentRef == null ||
                    documentRef.Document is SoundSetDocument == false)
                {
                    return docRefList;
                }
            }

            docRefList.Add(documentRef);
            SoundSet soundSet = (documentRef.Document as SoundSetDocument).SoundSet;
            SoundSetBankPack pack = (from Component c in soundSet.Children
                                     where c is SoundSetBankPack
                                     select c as SoundSetBankPack).FirstOrDefault();

            foreach (SoundSetBankBase soundSetBank in pack.Children)
            {
                GetDifferentVersionFilesWithBankFile(soundSetBank.FilePath, ref newVersionFiles, ref oldVersionFiles);
            }

            return docRefList;
        }

        public static void GetDifferentVersionFilesWithBankFile(string filePath, ref List<string> newVersionFiles, ref List<string> oldVersionFiles)
        {
            GetDifferentVersionFile(filePath, ref newVersionFiles, ref oldVersionFiles);
        }

        public static void GetDifferentVersionFile(string filePath, ref List<string> newVersionFiles, ref List<string> oldVersionFiles)
        {
            DocumentService documentService = DocumentService;
            ISoundFileDocumentReader reader = null;
            try
            {
                reader = documentService.Traits.GetDocumentReader(new FileResource(filePath)) as ISoundFileDocumentReader;
            }
            catch (FileNotSupportedVersionException)
            {
                newVersionFiles.Add(filePath);
            }
            catch
            {
            }

            if (reader == null)
            {
                return;
            }

            string documentVersion = reader.DocumentVersion;
            string fileVersion = reader.GetFileVersion(filePath);
            if (string.IsNullOrEmpty(documentVersion) == false &&
                string.IsNullOrEmpty(fileVersion) == false)
            {
                Version dv = new Version(documentVersion);
                Version fv = new Version(fileVersion);
                if (dv < fv)
                {
                    newVersionFiles.Add(filePath);
                }
                else if (dv > fv)
                {
                    oldVersionFiles.Add(filePath);
                }
            }
        }
    }
}
