﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;

    using NintendoWare.SoundFoundation.Core.Parameters;
    using NintendoWare.SoundFoundation.Parameters;
    using NintendoWare.SoundFoundation.Projects;
    /// <summary>
    ///
    /// </summary>
    public class PreviewStreamSound
    {
        public const string PlayTrack = "PreviewPlayTrack" + ParameterNames.TemporaryPostfix;
        public const string MuteTrack = "PreviewMuteTrack" + ParameterNames.TemporaryPostfix;

        /// <summary>
        ///
        /// </summary>
        public static void AddPlayParameter(StreamSoundBase streamSound)
        {
            if (streamSound != null)
            {
                foreach (StreamSoundTrackBase track in streamSound.Children)
                {
                    AddPlayParameter(track);
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public static void RemovePlayParameter(StreamSoundBase streamSound)
        {
            if (streamSound != null)
            {
                foreach (StreamSoundTrackBase track in streamSound.Children)
                {
                    RemovePlayParameter(track);
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public static void AddPlayMuteParameter(StreamSoundBase streamSound)
        {
            if (streamSound != null)
            {
                foreach (StreamSoundTrackBase track in streamSound.Children)
                {
                    AddPlayParameter(track);

                    if (track.PreviewMute != false)
                    {
                        AddMuteParameter(track);
                    }
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public static void RemovePlayMuteParameter(StreamSoundBase streamSound)
        {
            if (streamSound != null)
            {
                foreach (StreamSoundTrackBase track in streamSound.Children)
                {
                    track.Parameters.RemoveValue(PlayTrack);
                    track.Parameters.RemoveValue(MuteTrack);
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        private static void AddPlayParameter(StreamSoundTrackBase track)
        {
            track.Parameters.AddValue(PlayTrack, new BoolParameterValue(true));
        }

        /// <summary>
        ///
        /// </summary>
        private static void RemovePlayParameter(StreamSoundTrackBase track)
        {
            track.Parameters.RemoveValue(PlayTrack);
        }

        /// <summary>
        ///
        /// </summary>
        private static void AddMuteParameter(StreamSoundTrackBase track)
        {
            track.Parameters.AddValue(MuteTrack, new BoolParameterValue(true));
        }
    }
}
