﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Preset
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework.Resources;

    public class HistoryService : BookmarkService
    {
        private XmlBookmarkConfiguration xmlBookmarkConfiguration;

        public event EventHandler Changed;

        public HistoryService(XmlBookmarkConfiguration config)
        {
            this.HistoryMaximum = 100;
            this.xmlBookmarkConfiguration = config;
            this.BookmarkRoot = new BookmarkFolder(MessageResource.HistoryRootFolderLabel);
            this.SetBookmarkConfiguration(this.xmlBookmarkConfiguration);
            base.BookmarkChanged += OnBookmarkChanged;
        }

        public int HistoryMaximum { get; set; }

        public override void Add(Component component)
        {
            int count = this.BookmarkRoot.Children.Count;

            for (int i = count; this.HistoryMaximum <= i; i--)
            {
                Component removeComponent = this.BookmarkRoot.Children[i - 1];
                this.BookmarkRoot.Children.Remove(removeComponent);
            }

            this.Add(component, true);
        }

        public void UpdateName()
        {
            this.UpdateName(this.BookmarkRoot);
            OnBookmarkChanged(this, EventArgs.Empty);
        }

        public XmlBookmarkConfiguration GetHistoryList()
        {
            this.xmlBookmarkConfiguration = this.GetBookmarkConfiguration();
            return this.xmlBookmarkConfiguration;
        }

        private void UpdateName(BookmarkFolder folder)
        {
            foreach (Component component in folder.Children)
            {
                if (component is BookmarkFolder == true)
                {
                    this.UpdateName(component as BookmarkFolder);
                }
                else if (component is Bookmark)
                {
                    Bookmark bookmark = component as Bookmark;
                    string defaultName = this.GetDefaultName(bookmark);
                    if (string.IsNullOrEmpty(defaultName) == false)
                    {
                        bookmark.Name = defaultName;
                    }
                }
            }
        }

        private void OnBookmarkChanged(object sender, EventArgs e)
        {
            if (Changed != null)
            {
                Changed(sender, e);
            }
        }
    }
}
