﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework
{
    using System.Drawing;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Conversion.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// アプリケーション特性を取得します。
    /// </summary>
    public interface IApplicationTraits
    {
        /// <summary>
        /// アプリケーションアセンブリを取得します。
        /// </summary>
        Assembly ApplicationAssembly { get; }

        /// <summary>
        /// アプリケーションアイコンを取得します。
        /// </summary>
        Icon ApplicationIcon { get; }

        /// <summary>
        /// プラットフォームイメージを取得します。
        /// </summary>
        Image PlatformImage { get; }

        /// <summary>
        /// その他付加情報を取得します。
        /// </summary>
        string OtherAddedInfomation { get; }

        /// <summary>
        /// 製品名を取得します。
        /// </summary>
        string ProductName { get; }

        /// <summary>
        /// 製品バージョンを取得します。
        /// </summary>
        string ProductVersion { get; }

        /// <summary>
        /// 中間出力の特性を取得します。
        /// </summary>
        SoundIntermediateOutputTraits IntermediateOutputTraits { get; }

        /// <summary>
        /// バイナリ出力の特性を取得します。
        /// </summary>
        SoundBinaryOutputTraits BinaryOutputTraits { get; }

        /// <summary>
        /// サウンドプロジェクトコンバート特性を取得または設定します。
        /// </summary>
        SoundProjectConversionTraits ConversionTraits { get; }

        /// <summary>
        /// リストのカラム特性を取得します。
        /// </summary>
        Configurations.ListTraits ListTraits { get; }

        /// <summary>
        /// コンポーネントのインスタンス特性を取得します。
        /// </summary>
        SoundComponentTraits ComponentTraits { get; }
    }
}
