﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.FileFormats
{
    using System.IO;

    /// <summary>
    /// ファイルを解析します。
    /// </summary>
    public interface IFileParser
    {
        /// <summary>
        /// エンディアンを取得または設定します。
        /// </summary>
        bool IsLittleEndian { get; set; }

        /// <summary>
        /// 解析したファイルの情報を保持しているかどうかを調べます。
        /// </summary>
        bool IsParsed { get; }

        /// <summary>
        /// 解析したファイルが更新されているかどうかを調べます。
        /// </summary>
        bool IsUpdated { get; }

        /// <summary>
        /// ファイルを解析します。
        /// </summary>
        /// <param name="filePath"></param>
        void Parse(string filePath);
    }
}
