﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.FileFormats
{
    public static class FileUtil
    {
        /// <summary>
        /// OPUS ファイル対応かどうか設定、取得します。
        /// </summary>
        public static bool EnabledOpus
        {
            get; set;
        }

        /// <summary>
        /// OPUS ファイルなのか調べます。
        /// </summary>
        public static bool IsOpusFile(string filePath)
        {
            if (EnabledOpus == false)
            {
                return false; // 無効の場合は常に false。Opus ファイルかどうかの判断自体無効にします。
            }

            /// 現状では拡張子だけで判断します。
            return Path.GetExtension(filePath).ToLower() == ".opus" ? true : false;
        }
    }
}
