﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Diagnostics;

namespace NintendoWare.SoundMaker.Framework
{
    public static class CoreServicesProvider
    {
        private static ICoreServices _instance;
        private static readonly object _lock = new object();

        /// <summary>
        /// <see cref="ICoreServices"/> のインスタンスを取得します。
        /// </summary>
        public static ICoreServices Instance
        {
            get { return _instance; }
        }

        /// <summary>
        /// <see cref="ICoreServices"/> のインスタンス（シングルトン）を設定します。
        /// </summary>
        /// <param name="instance"></param>
        public static void SetInstance(ICoreServices instance)
        {
            Debug.Assert(_instance == null || instance == null || _instance == instance, nameof(instance));

            lock (_lock)
            {
                if (_instance == null)
                {
                    _instance = instance;
                }
                else if (instance == null)
                {
                    _instance = null;
                }
            }
        }
    }
}
