﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// 全ての URI 設定を格納します。
    /// </summary>
    public partial class XmlUris
    {
        /// <summary>
        /// XmlUris に含まれる全 XmlUri の一覧を取得します。
        /// </summary>
        /// <returns>全 XmlUri が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlUri> CreateDictionary()
        {
            Dictionary<string, XmlUri> result = new Dictionary<string, XmlUri>();
            if (null == Uri) { return result; }

            foreach (XmlUri xmlUri in Uri)
            {
                result.Add(xmlUri.Name, xmlUri);
            }

            return result;
        }
    }
}
