﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// 全てのツールページ設定を格納します。
    /// </summary>
    public partial class XmlToolPages
    {
        /// <summary>
        /// XmlToolPages に含まれる全 XmlToolPage の一覧を取得します。
        /// </summary>
        /// <returns>全 XmlToolPage が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlToolPage> CreateDictionary()
        {
            Dictionary<string, XmlToolPage> result = new Dictionary<string, XmlToolPage>();

            foreach (XmlToolPage xmlToolPage in ToolPage)
            {
                result.Add(xmlToolPage.Name, xmlToolPage);
            }

            return result;
        }
    }
}
