﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Configurations;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    public static class XmlSoundSetViewTypeEx
    {
        public static bool IsMultipleView(this XmlSoundSetViewType value)
        {
            switch (value)
            {
                case XmlSoundSetViewType.WaveSoundSet:
                case XmlSoundSetViewType.SequenceSoundSet:
                    return true;
            }

            return false;
        }

        public static XmlSoundSetViewType FromType(Type type)
        {
            if (null == type) { return XmlSoundSetViewType.None; }

            if (type == typeof(WaveSoundSetPack))
            {
                return XmlSoundSetViewType.WaveSoundSet;
            }
            if (type == typeof(WaveSoundSetBase))
            {
                return XmlSoundSetViewType.WaveSound;
            }
            if (type == typeof(SequenceSoundSetPack))
            {
                return XmlSoundSetViewType.SequenceSoundSet;
            }
            if (type == typeof(SequenceSoundSetBase))
            {
                return XmlSoundSetViewType.SequenceSound;
            }

            return XmlSoundSetViewType.None;
        }
    }
}
