﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using NintendoWare.SoundMaker.Framework.Configurations;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// 全てのリスト設定を格納します。
    /// </summary>
    public partial class XmlLists
    {
        public static bool Validate(IDictionary<string, XmlList> xmlLists)
        {
            if (null == xmlLists) { throw new ArgumentNullException("xmlLists"); }

            //foreach ( string listName in ListTraits.ListNames.Values ) {
            foreach (string listName in ApplicationBase.Instance.Traits.ListTraits.ListNames.Values)
            {

                if (!xmlLists.ContainsKey(listName)) { return false; }

                //ListTrait listTrait = ListTraits.Lists[ listName ];
                ListTrait listTrait = ApplicationBase.Instance.Traits.ListTraits.Lists[listName];

                IDictionary<string, Schemas.XmlListColumn> xmlListColumns =
                                xmlLists[listName].ListColumns.ExportDictionary();

                foreach (string columnName in listTrait.Columns)
                {
                    if (!xmlListColumns.ContainsKey(columnName)) { return false; }
                }

            }

            return true;
        }

        public bool Validate()
        {
            return Validate(ExportDictionary());
        }

        public XmlLists DeepClone()
        {
            List<XmlList> xmlLists = new List<XmlList>();

            foreach (XmlList xmlSrcList in List)
            {
                xmlLists.Add(xmlSrcList.DeepClone());
            }

            return new XmlLists()
            {
                List = xmlLists.ToArray(),
            };
        }

        /// <summary>
        /// XmlLists の内容をディクショナリにエクスポートします。
        /// </summary>
        /// <returns>全 XmlList が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlList> ExportDictionary()
        {
            Dictionary<string, XmlList> result = new Dictionary<string, XmlList>();

            foreach (XmlList xmlList in List)
            {
                result.Add(xmlList.Name, xmlList);
            }

            return result;
        }

        /// <summary>
        /// リスト設定をインポートします。
        /// </summary>
        /// <param name="xmlLists">リスト設定。</param>
        public void Import(IEnumerable<XmlList> xmlLists)
        {
            List = xmlLists.ToArray();
        }
    }
}
