﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using NintendoWare.SoundMaker.Framework.Configurations;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// リスト設定を格納します。
    /// </summary>
    public partial class XmlList
    {
        public XmlList DeepClone()
        {
            XmlListColumns xmlColumns = null;

            if (null != ListColumns)
            {

                xmlColumns = new XmlListColumns();

                if (null != ListColumns.ListColumn)
                {

                    List<XmlListColumn> workColumns = new List<XmlListColumn>();

                    foreach (XmlListColumn srcColumn in ListColumns.ListColumn)
                    {
                        workColumns.Add(
                            new XmlListColumn()
                            {
                                Name = srcColumn.Name,
                                Length = srcColumn.Length,
                                LengthSpecified = srcColumn.LengthSpecified,
                                Visible = srcColumn.Visible,
                            });
                    }

                    xmlColumns.ListColumn = workColumns.ToArray();

                }

            }

            return new XmlList()
            {
                Name = this.Name,
                SortKey = this.SortKey,
                SortOrder = this.SortOrder,
                ListColumns = xmlColumns,
            };
        }

        public bool Validate()
        {
            //if ( !ListTraits.Lists.ContainsKey( Name ) ) { return false; }
            if (!ApplicationBase.Instance.Traits.ListTraits.Lists.ContainsKey(Name)) { return false; }
            return Validate(ListColumns.ExportDictionary());
        }

        public bool Validate(IDictionary<string, XmlListColumn> xmlColumns)
        {
            if (null == xmlColumns) { throw new ArgumentNullException("xmlColumns"); }

            //ListTrait trait = ListTraits.Lists[ Name ];
            ListTrait trait = ApplicationBase.Instance.Traits.ListTraits.Lists[Name];

            foreach (string columnName in trait.Columns)
            {
                if (!xmlColumns.ContainsKey(columnName))
                {
#if DEBUG
                    System.Diagnostics.Debug.WriteLine( "XmlLists Validation Error : Column \"" + columnName + "\" is not found." );
#endif
                    return false;
                }
            }

            return true;
        }
    }
}
