﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// フレームウィンドウ設定を格納します。
    /// </summary>
    public partial class XmlFrameWindow
    {
        /// <summary>
        /// フレームウィンドウに含まれる全 XmlDockingHostControl の一覧を作成します。
        /// </summary>
        /// <returns>全 XmlDockingHostControl が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlDockingHostControl> CreateDockingHostDictionary()
        {
            Dictionary<string, XmlDockingHostControl> result = new Dictionary<string, XmlDockingHostControl>();

            if (null != SplitControl)
            {
                QueryDockingHostControls(SplitControl, result);
            }

            return result;
        }

        /// <summary>
        /// フレームウィンドウに含まれる全 XmlSplitControl の一覧を作成します。
        /// </summary>
        /// <returns>全 XmlDockingHostControl が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlSplitControl> CreateSplitDictionary()
        {
            Dictionary<string, XmlSplitControl> result = new Dictionary<string, XmlSplitControl>();

            if (null != SplitControl)
            {
                QuerySplitControls(SplitControl, result);
            }

            return result;
        }

        private void QueryDockingHostControls(XmlSplitControl splitControl, IDictionary<string, XmlDockingHostControl> result)
        {
            if (null == splitControl) { throw new ArgumentNullException("splitControl"); }
            if (null == result) { throw new ArgumentNullException("result"); }

            foreach (XmlControl control in splitControl.Controls.Items)
            {

                if (control is XmlDockingHostControl)
                {

                    XmlDockingHostControl dockingHostControl = control as XmlDockingHostControl;
                    result.Add(dockingHostControl.Name, dockingHostControl);

                }
                else if (control is XmlSplitControl)
                {
                    QueryDockingHostControls(control as XmlSplitControl, result);
                }

            }
        }

        private void QuerySplitControls(XmlSplitControl splitControl, IDictionary<string, XmlSplitControl> result)
        {
            if (null == splitControl) { throw new ArgumentNullException("splitControl"); }
            if (null == result) { throw new ArgumentNullException("result"); }

            if (null != splitControl.Name && 0 < splitControl.Name.Length)
            {
                result.Add(splitControl.Name, splitControl);
            }

            foreach (XmlControl control in splitControl.Controls.Items)
            {

                if (control is XmlSplitControl)
                {
                    QuerySplitControls(control as XmlSplitControl, result);
                }

            }
        }
    }
}
