﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using NintendoWare.SoundFoundation.Core.IO;

    /// <summary>
    /// 全ての DocumentView 設定を格納します。
    /// </summary>
    public partial class XmlDocumentViews
    {
        /// <summary>
        /// XmlDocumentViews に含まれる全 XmlDocumentView の一覧を取得します。
        /// </summary>
        /// <param name="basePath">基準パス。</param>
        /// <returns>全 XmlDocumentView が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlDocumentView> CreateDictionary(string basePath)
        {
            if (null == basePath) { throw new ArgumentNullException("basePath"); }

            Dictionary<string, XmlDocumentView> result = new Dictionary<string, XmlDocumentView>();
            if (null == Items) { return result; }

            foreach (XmlDocumentView xmlView in Items)
            {
                xmlView.FilePath = Path.Combine(basePath, xmlView.FilePath).GetFullPath();
                result.Add(xmlView.FilePath, xmlView);
            }

            return result;
        }
    }
}
