﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    public partial class XmlCommandBars
    {
        /// <summary>
        /// XmlCommandBars に含まれる全 XmlCommandBar の一覧を取得します。
        /// </summary>
        /// <returns>全 XmlCommandBar が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlCommandBar> CreateDictionary()
        {
            Dictionary<string, XmlCommandBar> result = new Dictionary<string, XmlCommandBar>();
            if (null == CommandBar) { return result; }

            foreach (XmlCommandBar xmlCommandBar in CommandBar)
            {
                result.Add(xmlCommandBar.Name, xmlCommandBar);
            }

            return result;
        }
    }
}
