﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// プロジェクト関連コマンドを管理します。
    /// </summary>
    public static class ProjectCommands
    {
        /// <summary>
        /// プロジェクト関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(ProjectCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// アイテムの追加。
        /// </summary>
        public static readonly Command AddItem = new Command("Project.AddItem", string.Empty);

        /// <summary>
        /// アイテムの挿入。
        /// </summary>
        public static readonly Command InsertItem = new Command("Project.InsertItem", string.Empty);

        /// <summary>
        /// 新しいサウンドセットを追加。
        /// </summary>
        public static readonly Command AddNewSoundSet =
            new Command("Project.AddNewSoundSet", MessageResource.Command_Project_AddNewSoundSet_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddNewSoundSet_Text,
#endif
            };

        /// <summary>
        /// 既存のサウンドセットを追加。
        /// </summary>
        public static readonly Command AddExistingSoundSet =
            new Command("Project.AddExistingSoundSet", MessageResource.Command_Project_AddExistingSoundSet_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddExistingSoundSet_Text,
#endif
            };

        /// <summary>
        /// ストリームサウンドの追加。
        /// </summary>
        public static readonly Command AddStreamSound =
            new Command("Project.AddStreamSound", MessageResource.Command_Project_AddStreamSound_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddStreamSound_Text,
#endif
            };

        /// <summary>
        /// ストリームサウンドトラックの追加。
        /// </summary>
        public static readonly Command AddStreamSoundTrack =
            new Command("Project.AddStreamSoundTrack", MessageResource.Command_Project_AddStreamSoundTrack_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddStreamSound_Text,
#endif
            };

        /// <summary>
        /// ウェーブサウンドセットの追加。
        /// </summary>
        public static readonly Command AddWaveSoundSet =
            new Command("Project.AddWaveSoundSet", MessageResource.Command_Project_AddWaveSoundSet_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddWaveSoundSet_Text,
#endif
            };

        /// <summary>
        /// ウェーブサウンドの追加。
        /// </summary>
        public static readonly Command AddWaveSound =
            new Command("Project.AddWaveSound", MessageResource.Command_Project_AddWaveSound_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddWaveSound_Text,
#endif
            };

        /// <summary>
        /// シーケンスサウンドの追加。
        /// </summary>
        public static readonly Command AddSequenceSound =
            new Command("Project.AddSequencesound", MessageResource.Command_Project_AddSequencesound_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddSequencesound_Text,
#endif
            };

        /// <summary>
        /// シーケンスサウンドセットの追加。
        /// </summary>
        public static readonly Command AddSequenceSoundSet =
            new Command("Project.AddSequenceSoundSet", MessageResource.Command_Project_AddSequenceSoundSet_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddSequenceSoundSet_Text,
#endif
            };

        /// <summary>
        /// バンクの追加。
        /// </summary>
        public static readonly Command AddBank =
            new Command("Project.AddBank", MessageResource.Command_Project_AddBank_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddBank_Text,
#endif
            };

        /// <summary>
        /// 波形アーカイブの追加。
        /// </summary>
        public static readonly Command AddWaveArchive =
            new Command("Project.AddWaveArchive", MessageResource.Command_Project_AddWaveArchive_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddWaveArchive_Text,
#endif
            };

        /// <summary>
        /// プレイヤーの追加。
        /// </summary>
        public static readonly Command AddPlayer =
            new Command("Project.AddPlayer", MessageResource.Command_Project_AddPlayer_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddPlayer_Text,
#endif
            };

        /// <summary>
        /// グループの追加。
        /// </summary>
        public static readonly Command AddGroup =
            new Command("Project.AddGroup", MessageResource.Command_Project_AddGroup_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddGroup_Text,
#endif
            };

        /// <summary>
        /// グループアイテムの追加。
        /// </summary>
        public static readonly Command AddGroupItem =
            new Command("Project.AddGroupItem", MessageResource.Command_Project_AddGroupItem_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddGroupItem_Text,
#endif
            };

        /// <summary>
        /// インストルメントの追加。
        /// </summary>
        public static readonly Command AddInstrument =
            new Command("Project.AddInstrument", MessageResource.Command_Project_AddInstrument_Name)
            {
#if false
                Text = MessageResource.Command_Project_AddInstrument_Text,
#endif
            };

        /// <summary>
        /// ストリームサウンドの挿入。
        /// </summary>
        public static readonly Command InsertStreamSound =
            new Command("Project.InsertStreamSound", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertStreamSound_Text,
#endif
            };

        /// <summary>
        /// ストリームサウンドトラックの挿入。
        /// </summary>
        public static readonly Command InsertStreamSoundTrack =
            new Command("Project.InsertStreamSoundTrack", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertStreamSoundTrack_Text,
#endif
            };

        /// <summary>
        /// ウェーブサウンドセットの挿入。
        /// </summary>
        public static readonly Command InsertWaveSoundSet =
            new Command("Project.InsertWaveSoundSet", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertWaveSoundSet_Text,
#endif
            };

        /// <summary>
        /// ウェーブサウンドの挿入。
        /// </summary>
        public static readonly Command InsertWaveSound =
            new Command("Project.InsertWaveSound", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertWaveSound_Text,
#endif
            };

        /// <summary>
        /// シーケンスサウンドの挿入。
        /// </summary>
        public static readonly Command InsertSequenceSound =
            new Command("Project.InsertSequencesound", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertSequencesound_Text,
#endif
            };

        /// <summary>
        /// シーケンスサウンドセットの挿入。
        /// </summary>
        public static readonly Command InsertSequenceSoundSet =
            new Command("Project.InsertSequenceSoundSet", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertSequenceSoundSet_Text,
#endif
            };

        /// <summary>
        /// バンクの挿入。
        /// </summary>
        public static readonly Command InsertBank =
            new Command("Project.InsertBank", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertBank_Text,
#endif
            };

        /// <summary>
        /// 波形アーカイブの挿入。
        /// </summary>
        public static readonly Command InsertWaveArchive =
            new Command("Project.InsertWaveArchive", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertWaveArchive_Text,
#endif
            };

        /// <summary>
        /// プレイヤーの挿入。
        /// </summary>
        public static readonly Command InsertPlayer =
            new Command("Project.InsertPlayer", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertPlayer_Text,
#endif
            };

        /// <summary>
        /// グループの挿入。
        /// </summary>
        public static readonly Command InsertGroup =
            new Command("Project.InsertGroup", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertGroup_Text,
#endif
            };

        /// <summary>
        /// グループアイテムの挿入。
        /// </summary>
        public static readonly Command InsertGroupItem =
            new Command("Project.InsertGroupItem", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertGroupItem_Text,
#endif
            };

        /// <summary>
        /// インストルメントの挿入。
        /// </summary>
        public static readonly Command InsertInstrument =
            new Command("Project.InsertInstrument", string.Empty)
            {
#if false
                Text = MessageResource.Command_Project_InsertInstrument_Text,
#endif
            };

        /// <summary>
        /// コンバート。
        /// </summary>
        public static readonly Command Convert =
            new Command("Project.Convert", MessageResource.Command_Project_Convert_Name)
            {
#if false
                Text = MessageResource.Command_Project_Convert_Text,
#endif
                Image = ImageResource.BitmapIconConvert.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 再コンバート。
        /// </summary>
        public static readonly Command Reconvert =
            new Command("Project.Reconvert", MessageResource.Command_Project_Reconvert_Name)
            {
#if false
                Text = MessageResource.Command_Project_Reconvert_Text,
#endif
                Image = ImageResource.BitmapIconReconvert.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// 指定アイテムを再コンバート。
        /// </summary>
        public static readonly Command SelectReconvert =
            new Command("Project.SelectReconvert", MessageResource.Command_Project_SelectReconvert_Name)
            {
#if false
                Text = MessageResource.Command_Project_SelectReconvert_Text,
#endif
                Image = ImageResource.BitmapIconSelectReconvert.MakeNewTransparent(UIServiceBase.TransparentColor),
            };

        /// <summary>
        /// smfファイルコンバート。
        /// </summary>
        public static readonly Command ConvertSmfFile =
            new Command("Project.ConvertSmfFile", MessageResource.Command_Project_ConvertSmfFile_Name)
            {
#if false
                Text = MessageResource.Command_Project_ConvertSmfFile_Text,
#endif
            };

        /// <summary>
        /// テンプレートテキストシーケンス書き出し
        /// </summary>
        public static readonly Command OutputTemplateTextSequence =
            new Command("Project.OutputTemplateTextSequence", MessageResource.Command_Project_OutputTemplateTextSequence_Name)
            {
#if false
                Text = MessageResource.Command_Project_OutputTemplateTextSequence_Text,
#endif
            };

        /// <summary>
        /// プロジェクトの修復。
        /// </summary>
        public static readonly Command RepairProject =
            new Command("Project.RepairProject", MessageResource.Command_Project_RepairProject_Name)
            {
#if false
                Text = MessageResource.Command_Project_RepairProject_Text,
#endif
            };

        /// <summary>
        /// プロジェクトの設定。
        /// </summary>
        public static readonly Command ShowProjectSettings =
            new Command("Project.ShowProjectSettings", MessageResource.Command_Project_ShowProjectSettings_Name)
            {
#if false
                Text = MessageResource.Command_Project_ShowProjectSettings_Text,
#endif
            };
    }
}
