﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;

    /// <summary>
    /// パーカッションリスト関連コマンドを管理します。
    /// </summary>
    public static class PercussionListCommands
    {
        /// <summary>
        /// パーカッションリスト関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(PercussionListCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// キーリージョンの分割。
        /// </summary>
        public static readonly Command SplitKeyRegion =
            new Command("PercussionList.SplitKeyRegion", string.Empty)
            {
#if false
                Text = MessageResource.Command_PercussionList_SplitKeyRegion_Text,
#endif
            };
    }
}
