﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

using NintendoWare.SoundFoundation.CommandHandlers;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Operations;
using NintendoWare.SoundFoundation.Parameters;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Commands;
using NintendoWare.SoundMaker.Framework.Windows;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public abstract class EditCommandHandler : CommandHandler
    {
        private string _CommandID;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public EditCommandHandler(string commandID, IQueryCommandParameter queryParameter) :
            base(queryParameter)
        {
            _CommandID = commandID;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string TargetCommandID
        {
            get { return _CommandID; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            Component[] components = GetTargetComponents(parameters);

            if (null == GetTargetDocument(parameters)) { return CommandStatus.SupportedAndVisible; }
            if (null == components) { return CommandStatus.SupportedAndVisible; }

            return components.Length > 0 ? CommandStatus.SupportedAndEnabledAndVisible : CommandStatus.SupportedAndVisible;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected ComponentService GetTargetComponentService(IQueryCommandParameter parameters)
        {
            if (null == parameters) { throw new ArgumentNullException("parameters"); }

            if (!parameters.ContainsParameter(CommandParameterNames.TargetComponentService))
            {
                return null;
            }

            return parameters.GetParameter(CommandParameterNames.TargetComponentService)
                   as ComponentService;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected SoundDocument GetTargetDocument(IQueryCommandParameter parameters)
        {
            if (null == parameters) { throw new ArgumentNullException("parameters"); }

            if (!parameters.ContainsParameter(CommandParameterNames.TargetDocuments))
            {
                return null;
            }

            return (parameters.GetParameter(CommandParameterNames.TargetDocuments)
                     as IEnumerable<SoundDocument>).FirstOrDefault();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected Component[] GetTargetComponents(IQueryCommandParameter parameters)
        {
            if (null == parameters) { throw new ArgumentNullException("parameters"); }

            if (!parameters.ContainsParameter(CommandParameterNames.TargetComponents))
            {
                return null;
            }

            return (parameters.GetParameter(CommandParameterNames.TargetComponents)
                     as IEnumerable<Component>).ToArray();
        }
    }
}
