﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;

using NintendoWare.SoundFoundation.CommandHandlers;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Operations;
using NintendoWare.SoundFoundation.Parameters;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.Commands;
using NintendoWare.SoundMaker.Framework.Windows;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// "切り取り"ハンドラ
    /// </summary>
    public class CutHandler : DeleteHandlerBase
    {
        ///--------------------------------
        /// <summary>
        /// </summary>
        public CutHandler(IQueryCommandParameter queryParameter)
            : base(EditCommands.Cut.ID, queryParameter)
        {
        }

        protected override bool OnDeleting(IQueryCommandParameter parameters, Component[] components)
        {
            Debug.Assert(null != parameters, "invalid argument");
            Debug.Assert(null != components, "invalid argument");

            string[] columnNames = (string[])parameters.GetParameter("ColumnNames");
            ClipboardService.Copy(components, columnNames);

            return true;
        }
    }
}
