﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework
{
    using System.Drawing;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Conversion.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// アプリケーション特性を格納します。
    /// </summary>
    public class ApplicationTraits : IApplicationTraits
    {
        /// <summary>
        /// アプリケーションアセンブリを取得します。
        /// </summary>
        public Assembly ApplicationAssembly { get; set; }

        /// <summary>
        /// アプリケーションアイコンを取得します。
        /// </summary>
        public Icon ApplicationIcon { get; set; }

        /// <summary>
        /// プラットフォームイメージを取得します。
        /// </summary>
        public Image PlatformImage { get; set; }

        /// <summary>
        /// その他付加情報を取得します。
        /// </summary>
        public string OtherAddedInfomation { get; set; }

        /// <summary>
        /// 製品名を取得します。
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// 製品バージョンを取得します。
        /// </summary>
        public string ProductVersion { get; set; }

        /// <summary>
        /// サウンド中間出力特性を取得または設定します。
        /// </summary>
        public SoundIntermediateOutputTraits IntermediateOutputTraits { get; set; }

        /// <summary>
        /// サウンドバイナリ出力特性を取得または設定します。
        /// </summary>
        public SoundBinaryOutputTraits BinaryOutputTraits { get; set; }

        /// <summary>
        /// サウンドプロジェクトコンバート特性を取得または設定します。
        /// </summary>
        public SoundProjectConversionTraits ConversionTraits { get; set; }

        /// <summary>
        /// リストのカラム特性を取得または設定します。
        /// </summary>
        public Configurations.ListTraits ListTraits { get; set; }

        /// <summary>
        /// コンポーネントのインスタンス特性を取得または設定します。
        /// </summary>
        public SoundComponentTraits ComponentTraits { get; set; }
    }
}
