﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Windows.Forms
{
    using System;
    using System.Diagnostics;
    using System.Drawing;
    using System.Linq;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundFoundation.Windows.Forms;
    using NintendoWare.SoundMaker.Configurations;
    using NintendoWare.SoundMaker.Configurations.Schemas;
    using NintendoWare.SoundMaker.Framework;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using NintendoWare.SoundMaker.Preview;
    using NintendoWare.SoundMaker.Preview.Communications;
    using NintendoWare.SoundMaker.Preview.Configurations;
    using FrameworkResources = NintendoWare.SoundMaker.Framework.Resources;

    public partial class InGamePanelCommon : InGamePanel
    {
        public InGamePanelCommon()
        {
            InitializeComponent();

            ListCtrlCommon.AddListColumnStyle(listCtrl);

            //
            FormsApplicationCommon.Instance.CommunicationService.SndEditConnectionChanged += OnSndEditConnectionChanged;
        }

        /// <summary>
        ///
        /// </summary>
        protected override bool CanPlay
        {
            get
            {
                return PreviewPlayerOperator.SelectedPreviewPlayer != null ? true : false;
            }
        }

        /// <summary>
        ///
        /// </summary>
        protected override void Play(Sound sound)
        {
            PreviewPlayerOperator.Play(sound);
        }
    }
}
