﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Text;
    using System.Windows.Forms;
    using MCS = NintendoWare.SoundMaker.Preview.MCS;

    /// <summary>
    /// 通信中に表示するダイアログです。
    /// このダイアログは、MCSに接続しているときにしか表示してはいけません。
    /// このダイアログを表示すると MCSEchoSoundPacket パケットを送信し、応答があればダイアログを閉じます。
    /// </summary>
    public partial class CommunicatingDialog : Form
    {
        //private MCS.Tool.Sound.MCSEchoSoundPacket Packet = null;
        private NintendoWare.SoundMaker.Framework.Preview.Communications.Tool.EchoSoundPacket packet = null;

        public CommunicatingDialog()
        {
            InitializeComponent();
        }

        public string Message
        {
            set { MessageLabel.Text = value; }
        }

        private void CommunicatingDialog_Shown(object sender, EventArgs e)
        {
            //Packet = MCS.Tool.Sound.MCSEchoSoundPacket.Send();
            packet = NintendoWare.SoundMaker.Framework.Preview.Communications.Tool.EchoSoundPacket.Send();
            if (packet != null)
            {
                timer1.Start();
            }
            else
            {
                Close();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if (packet.ReadFlag)
            {
                Close();
            }
        }
    }
}
